<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TiMovimiento
 * 
 * @property int $id
 * @property string $tipo_movimiento
 * @property string $usuario
 * @property int $equipo_id
 * @property Carbon $movement_date
 * @property string|null $comentarios
 * @property Carbon $create_at
 *
 * @package App\Models
 */
class TiMovimiento extends Model
{
	protected $table = 'ti_movimientos';
	public $timestamps = false;

	protected $casts = [
		'equipo_id' => 'int',
		'movement_date' => 'datetime',
		'create_at' => 'datetime'
	];

	protected $fillable = [
		'tipo_movimiento',
		'usuario',
		'equipo_id',
		'movement_date',
		'comentarios',
		'create_at'
	];
}
