@extends('adminlte::page')

@section('title', 'Sistema TI')

@section('content_header')
    <h1 class="m-0 text-dark">Movimiento de equipo:: Entrega / Recibo</h1>
@stop

@section('content')
<style>
    @media print{
        .flex-container table,.col-sm-6{
            display:none;
        }
        *{
            overflow-y: hidden!important;
          
             color:#000!important;
        }
        .modal button{
            display:none;
        }
 .modal-dialog {
  max-width: 100%;
  width: 100%;
  padding:0!important;
  margin-top:-25px;

  overflow: hidden;
 }
}

</style>
<link rel="stylesheet" href="{{ URL::asset('plugins/sceditor/minified/themes/default.min.css') }}" />

<script src="{{ URL::asset('plugins/sceditor/minified/sceditor.min.js')}}?v={{AppHelper::getVersion()}}"></script>
<script src="{{ URL::asset('plugins/sceditor/minified/icons/monocons.js')}}?v={{AppHelper::getVersion()}}"></script>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <form onsubmit="return save(event)" id="addForm">
                            <div class="row" style="">
                               
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Usuario</label>
                                    <select id="usuario" name="usuario" class="form-control w-100" required>
                                        @foreach($usuarios as $usuario)
                                            <option value="{{$usuario->id}}">{{$usuario->nombre." ".$usuario->apellidos}}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Tipo de movimiento:</label>
                                    <select id="tipo_movimiento" name="tipo_movimiento" class="form-control form-select w-100" required>
                                        <option value="entrega">Entrega</option>
                                        <option value="recibo">Recibo</option>
                                    </select>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Fecha Movimiento</label>
                                    <input type="date" id="movement_date" value="{{date('Y-m-d')}}" name="movement_date" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Fecha Hora</label>
                                    <input type="time" id="hour_date" name="hour_date" value="{{date('H:i')}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-12">
                                    <label class="w-100 font-weight-bold">Equipo</label>
                                    <select id="equipo_id" name="equipo_id" class="form-control form-select w-100" required>
                                        @foreach($equipos as $equipo)
                                            <option value="{{$equipo->id}}">{{$equipo->numero_serie." ".$equipo->marca." ".$equipo->modelo}}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                
                                <div class="col-sm-12">
                                    <label class="w-100 font-weight-bold">Comentarios</label>
                                    <textarea id="comentarios" name="comentarios" class="form-control w-100" ></textarea>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                               
                                <div class="col-sm-12  d-flex justify-content-end" style="margin-top:10px">
                                   
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                </div>
                            </div>
                        </form>
                        <div class="row" style="margin-top:25px">
                        <table class="table table-striped table-bordered w-100">
                                            <thead>
                                                <tr>
                                                    <th>Fecha</th>
                                                    <th>Tipo</th>
                                                    <th>Usuario</th>
                                                    <th>Marca</th>
                                                    <th>Modelo</th>
                                                    <th>Número de Serie</th>
                                                    <th style="width:75px;" class="noExport">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($movimientos as $nivel)
                                                    <tr>
                                                        <td>
                                                            {{date_format(date_create($nivel->movement_date),"H:i d-m-Y")}}
                                                        </td>
                                                        <td>
                                                            @if($nivel->tipo_movimiento=="entrega")
                                                                Entrega
                                                            @endif
                                                            @if($nivel->tipo_movimiento!="entrega")
                                                                Recibido
                                                            @endif
                                                        </td>
                                                        <td>
                                                            {{$nivel->usuario}}
                                                        </td>
                                                        <td>
                                                            {{$nivel->marca}}
                                                        </td>
                                                        <td>
                                                            {{$nivel->modelo}}
                                                        </td>
                                                      
                                                        <td>
                                                            {{$nivel->numero_serie}}
                                                        </td>
                                                      
                                                        
                                                        <td style="width:125px;" class="noExport" >
                                                            <div class="d-flex">
                                                            
                                                            
                                                            <a href="#" onclick="loadPurchase({{$nivel->idM}})"  class="btn btn-success text-white" style="margin-left:5px;">
                                                                        <i class="fa fa-eye"></i>
                                                            </a>
                                                            <form action='{{route("inventario.destroy", [$nivel])}}' method="post" onsubmit="return validate(event,this,{{$nivel->idM}},1)">
                                                                    @method("delete")
                                                                    @csrf
                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">
                                                                        <i class="fa fa-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                       
                                                        </td>
                                                           
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>  
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $route2 = route("movimientos.index");?>
<input type="hidden" value="{{$route2}}" id="route" />
@include('movimientos/modal')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js" defer></script>
<script src="{{ URL::asset('js/movimientos/add.js')}}?v={{AppHelper::getVersion()}}"></script>  

@stop
