@extends('adminlte::page')

@section('title', 'Sistema TI')

@section('content_header')
    <h1 class="m-0 text-dark">Compras::Editar</h1>
@stop

@section('content')
<link rel="stylesheet" href="{{ URL::asset('plugins/sceditor/minified/themes/default.min.css') }}" />

<script src="{{ URL::asset('plugins/sceditor/minified/sceditor.min.js')}}?v={{AppHelper::getVersion()}}"></script>
<script src="{{ URL::asset('plugins/sceditor/minified/icons/monocons.js')}}?v={{AppHelper::getVersion()}}"></script>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <form onsubmit="return save(event)" id="addForm">
                            <div class="row" style="">
                               
                            <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Numero de pedido</label>
                                    <input type="text" id="num_pedido" name="num_pedido" value="{{$equipo->num_pedido}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Fecha</label>
                                    <input type="date" id="fecha" name="fecha" value="{{date_format(date_create($equipo->fecha),"Y-m-d")}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Monto</label>
                                    <input type="text" id="monto" name="monto" value="{{$equipo->monto}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Numero de tarjeta</label>
                                    <input type="text" id="num_tarjeta" name="num_tarjeta" value="{{$equipo->num_tarjeta}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Factura</label>
                                    <input type="file" id="fac" name="fac" class="form-control w-100" />
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Carta de Autorizacion</label>
                                    <input type="file" id="carta" name="carta" class="form-control w-100" />
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">XLM</label>
                                    <input type="file" id="xml" name="xml" class="form-control w-100" />
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-12  d-flex justify-content-end" style="margin-top:10px">
                                   <input type="hidden" id="id" name="id" value="{{$equipo->id}}" />
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $route2 = route("compras.index");?>
<input type="hidden" value="{{$route2}}" id="route" />
<script src="{{ URL::asset('js/compras/edit.js')}}?v={{AppHelper::getVersion()}}"></script>  

@stop
