<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TiInventarioEquipo
 * 
 * @property int $id
 * @property string|null $so
 * @property string|null $estado
 * @property string|null $departamento
 * @property string|null $marca
 * @property string|null $modelo
 * @property string|null $numero_serie
 * @property int|null $isPC
 * @property string|null $ip
 * @property string|null $mac
 * @property string|null $nombre_plan
 * @property string|null $IMEI
 * @property string|null $num_movil
 * @property int $tipo_equipo
 * @property string|null $id_equipo
 * @property string|null $ubicacion
 * @property string|null $hd
 * @property string|null $ram
 * @property string|null $procesador
 * @property string|null $empresa
 * @property string|null $licencia
 * @property float|null $costo
 * @property string|null $tipo_cartucho
 * @property int $status
 * @property Carbon $create_at
 *
 * @package App\Models
 */
class TiInventarioEquipo extends Model
{
	protected $table = 'ti_inventario_equipos';
	public $timestamps = false;

	protected $casts = [
		'isPC' => 'int',
		'tipo_equipo' => 'int',
		'costo' => 'float',
		'status' => 'int',
		'create_at' => 'datetime'
	];

	protected $fillable = [
		'so',
		'estado',
		'departamento',
		'marca',
		'modelo',
		'numero_serie',
		'isPC',
		'ip',
		'mac',
		'nombre_plan',
		'IMEI',
		'num_movil',
		'tipo_equipo',
		'id_equipo',
		'ubicacion',
		'hd',
		'ram',
		'procesador',
		'empresa',
		'licencia',
		'costo',
		'tipo_cartucho',
		'status',
		'create_at'
	];
}
