<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Documento
 * 
 * @property int $idDocumento
 * @property int $idModulo
 * @property string $nombre
 * @property string $foto
 * @property int $estado
 * @property string|null $archivo
 *
 * @package App\Models
 */
class Documento extends Model
{
	protected $table = 'documentos';
	protected $primaryKey = 'idDocumento';
	public $timestamps = false;

	protected $casts = [
		'idModulo' => 'int',
		'estado' => 'int'
	];

	protected $fillable = [
		'idModulo',
		'nombre',
		'foto',
		'estado',
		'archivo'
	];
}
