<?php

namespace App\Http\Controllers;

use App\Models\TiVpn;
use App\Models\Usuario;
use Illuminate\Http\Request;

class VPNController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    public function index()
    {
        //
        $equipos = TiVpn::where('status','<=','1')->get();
        foreach ($equipos as $key => $value) {
            $usuario=Usuario::where('sistema','=','Panel')->where('id','=',$value->usuario)->first();
            $equipos[$key]->usuario = $usuario->nombre." ".$usuario->apellidos;
        }
        $data=[
            "equipos"=>$equipos
        ];
        return view("vpn.index",$data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $usuarios=Usuario::where('sistema','=','Panel')->get();
        $data=[
            "usuarios"=>$usuarios
        ];
        return view('vpn.add',$data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = new TiVpn($input);
            $equipo['status']=1;
            $equipo['create_at']=date('Y-m-d');
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $usuarios=Usuario::where('sistema','=','Panel')->get();
        $equipo = TiVpn::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo,
            "usuarios"=>$usuarios
        ];
        return view('vpn.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = TiVpn::where('id','=',$input['id'])->first();
            $equipo->nombre =$input['nombre'];
            $equipo->usuario =$input['usuario'];
            $equipo->password =$input['password'];
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $input = $request->all();
        try{
            $equipo = TiVpn::where('id','=',$input['id'])->first();
            $equipo->status = 2;
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
        //
    }
}
