<?php

namespace App\Http\Controllers;

use App\Models\TiInventarioEquipo;
use App\Models\TiMovimiento;
use App\Models\TiProveedore;
use App\Models\Usuario;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    public function index()
    {

    }
    public function historial(){
        $equipos = TiInventarioEquipo::where('status','<=','1')->get();
        $data=[
            'equipos'=>$equipos
        ];
        return view('reports.historial',$data);
    }
    public function historial_usuario(){
        $usuarios=Usuario::where('sistema','=','Panel')->get();
        $data=[
            'usuarios'=>$usuarios
        ];
        return view('reports.historial_usuario',$data);
    }
    public function estados(){
        $equipos = TiInventarioEquipo::where('status','<=','1')->get();
        $data=[
            'equipos'=>$equipos
        ];
        return view('reports.status',$data);
    }
    public function getHistorial(Request $request){

        $input =$request->all();
        $movimientos = TiMovimiento::select("ti_inventario_equipos.*","ti_movimientos.*","ti_movimientos.id as idM")->join('ti_inventario_equipos','ti_inventario_equipos.id','=','ti_movimientos.equipo_id')->where('equipo_id','=',$input['equipo_id'])->orderby("ti_movimientos.id","DESC")->get();
        foreach ($movimientos as $key => $value) {
            $usuario=Usuario::where('sistema','=','Panel')->where('id','=',$value->usuario)->first();
            $movimientos[$key]->usuario = $usuario->nombre." ".$usuario->apellidos;
        }
        echo json_encode($movimientos);
    }
    public function getHistorialUsuario(Request $request){

        $input =$request->all();
        $movimientos = TiMovimiento::select("ti_inventario_equipos.*","ti_movimientos.*","ti_movimientos.id as idM")->join('ti_inventario_equipos','ti_inventario_equipos.id','=','ti_movimientos.equipo_id')->where('ti_movimientos.usuario','=',$input['usuario'])->orderby("ti_movimientos.id","DESC")->get();
        foreach ($movimientos as $key => $value) {
            $usuario=Usuario::where('sistema','=','Panel')->where('id','=',$value->usuario)->first();
            $movimientos[$key]->usuario = $usuario->nombre." ".$usuario->apellidos;
        }
        echo json_encode($movimientos);
    }
    public function getEstados(Request $request){

        $input =$request->all();
        $movimientos = \DB::select('Select DISTINCT(equipo_id) as equipo_id from ti_movimientos order by id desc;');
        foreach ($movimientos as $key => $value) {
            $movimiento = TiMovimiento::join('ti_inventario_equipos','ti_inventario_equipos.id','=','ti_movimientos.id')->where('ti_movimientos.equipo_id','=',$value->equipo_id)->orderby('ti_movimientos.id',"DESC")->first();
            $movimientos[$key]->usuario=$movimiento->usuario;
            $movimientos[$key]->movement_date=$movimiento->movement_date;
            $movimientos[$key]->comentarios=$movimiento->comentarios;
            $movimientos[$key]->tipo_movimiento=$movimiento->tipo_movimiento;
            $movimientos[$key]->marca=$movimiento->marca;
            $movimientos[$key]->modelo=$movimiento->modelo;
            $movimientos[$key]->numero_serie=$movimiento->numero_serie;
            $value->usuario =  $movimientos[$key]->usuario;
            $usuario=Usuario::where('sistema','=','Panel')->where('id','=',$value->usuario)->first();
            $movimientos[$key]->usuario = $usuario->nombre." ".$usuario->apellidos;
        }
        echo json_encode($movimientos);
    }
}
/*

select DISTINCT equipo_id,tipo_movimiento,marca,modelo,numero_serie,movement_date,comentarios,idM,usuario from( SELECT ti_movimientos.equipo_id,ti_movimientos.tipo_movimiento,ti_inventario_equipos.marca,ti_inventario_equipos.modelo,ti_inventario_equipos.numero_serie,ti_movimientos.movement_date,ti_movimientos.comentarios,ti_movimientos.id as idM,ti_movimientos.usuario FROM `ti_movimientos` inner join ti_inventario_equipos on ti_movimientos.equipo_id=ti_inventario_equipos.id order by ti_movimientos.id DESC ) AS movimientos order by equipo_id DESC;

*/