<?php

namespace App\Http\Controllers;

use App\Models\TiInventarioEquipo;
use App\Models\TiMovimiento;
use App\Models\Usuario;
use Illuminate\Http\Request;

class MovimientosController extends Controller
{
    //
    public function __construct(Request $request){
        parent::__construct($request);
    }

    public function getData(Request $request){
        $input = $request->all();
        //$equipo = TiInventarioEquipo::where('status','<=','1')->get();
        $movimiento = TiMovimiento::select("ti_inventario_equipos.*","ti_movimientos.*","ti_movimientos.id as idM")->join('ti_inventario_equipos','ti_inventario_equipos.id','=','ti_movimientos.equipo_id')->orderby("ti_movimientos.id","DESC")->where("ti_movimientos.id","=",$input['id'])->first();

        $view=view('movimientos.data',['movimiento'=>$movimiento]);
        echo $view;
    }
    public function index(){
        date_default_timezone_set('America/Mexico_City');
        $equipos = TiInventarioEquipo::where('status','<=','1')->get();
        $usuarios=Usuario::where('sistema','=','Panel')->get();
        $movimientos = TiMovimiento::select("ti_inventario_equipos.*","ti_movimientos.*","ti_movimientos.id as idM")->join('ti_inventario_equipos','ti_inventario_equipos.id','=','ti_movimientos.equipo_id')->orderby("ti_movimientos.id","DESC")->limit(25)->get();
        foreach ($movimientos as $key => $value) {
            $usuario=Usuario::where('sistema','=','Panel')->where('id','=',$value->usuario)->first();
            $movimientos[$key]->usuario = $usuario->nombre." ".$usuario->apellidos;
        }
        $data=[
            "equipos"=>$equipos,
            "movimientos"=>$movimientos,
            "usuarios"=>$usuarios
        ];
        return view('movimientos.create',$data);
    }
    public function store(Request $request){
        $input = $request->all();

        try{
            $equipo = new TiMovimiento($input);
            $equipo['movement_date']= date_format(date_create($equipo['movement_date']),"Y-m-d")." ". $input['hour_date'];
            $equipo['create_at']=date('Y-m-d');
          
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }
    public function destroy(Request $request){
        $input = $request->all();

        try{
            $equipo =TiMovimiento::where('id','=',$input['id'])->first();
            \Log::emergency(json_encode($equipo));
            $equipo->delete();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }
}
