<?php

namespace App\Http\Controllers;

use App\Models\TiInventarioEquipo;
use Illuminate\Http\Request;

class EquiposController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }
    public function inventario(){
        $equipos = TiInventarioEquipo::where('tipo_equipo','=',0)->where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("inventarios.index",$data);
    }
    public function ups(){
        $equipos = TiInventarioEquipo::where('tipo_equipo','=',1)->where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("ups.index",$data);
    }
    public function monitores(){
        $equipos = TiInventarioEquipo::where('tipo_equipo','=',2)->where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("monitores.index",$data);
    }
    public function moviles(){
        $equipos = TiInventarioEquipo::where('tipo_equipo','=',3)->where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("moviles.index",$data);
    }
    public function impresoras(){
        $equipos = TiInventarioEquipo::where('tipo_equipo','=',4)->where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("impresoras.index",$data);
    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $data=[];
        return view('inventarios.add');
    }
    public function ups_add()
    {
        //
        $data=[];
        return view('ups.add');
    }
   
    public function monitores_add()
    {
        //
        $data=[];
        return view('monitores.add');
    }
    public function moviles_add()
    {
        //
        $data=[];
        return view('moviles.add');
    }
    public function impresoras_add()
    {
        //
        $data=[];
        return view('impresoras.add');
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = new TiInventarioEquipo($input);
            $equipo['status']=1;
            $equipo['create_at']=date('Y-m-d');
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $equipo = TiInventarioEquipo::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('inventarios.edit',$data);
    }
    public function ups_edit(string $id)
    {
        //
        $equipo = TiInventarioEquipo::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('ups.edit',$data);
    }
    public function monitores_edit(string $id)
    {
        //
        $equipo = TiInventarioEquipo::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('monitores.edit',$data);
    }
    public function moviles_edit(string $id)
    {
        //
        $equipo = TiInventarioEquipo::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('moviles.edit',$data);
    }
    public function impresoras_edit(string $id)
    {
        //
        $equipo = TiInventarioEquipo::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('impresoras.edit',$data);
    }
    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = TiInventarioEquipo::where('id','=',$input['id'])->first();
            if($input['tipo_equipo']==0){
                $equipo->marca =$input['marca'];
                $equipo->modelo =$input['modelo'];
                $equipo->departamento =$input['departamento'];
                $equipo->numero_serie =$input['numero_serie'];
                $equipo->isPC =$input['isPC'];
                $equipo->estado =$input['estado'];
                $equipo->ip =$input['ip'];
                $equipo->mac =$input['mac'];
                $equipo->so =$input['so'];
                $equipo->id_equipo =$input['id_equipo'];
                $equipo->ubicacion =$input['ubicacion'];
                $equipo->hd =$input['hd'];
                $equipo->ram =$input['ram'];
                $equipo->procesador =$input['procesador'];
                $equipo->empresa =$input['empresa'];
                $equipo->licencia =$input['licencia'];
                $equipo->costo =$input['costo'];
            }else if($input['tipo_equipo']==1 || $input['tipo_equipo']==2){
                $equipo->marca =$input['marca'];
                $equipo->modelo =$input['modelo'];
                $equipo->numero_serie =$input['numero_serie'];
            }else if($input['tipo_equipo']==3){
                $equipo->costo =$input['costo'];
                $equipo->empresa =$input['empresa'];
                $equipo->ubicacion =$input['ubicacion'];
                $equipo->ram =$input['ram'];
                $equipo->marca =$input['marca'];
                $equipo->modelo =$input['modelo'];
                $equipo->numero_serie =$input['numero_serie'];
                $equipo->IMEI =$input['IMEI'];
                $equipo->num_movil =$input['num_movil'];
                $equipo->nombre_plan =$input['nombre_plan'];
            }else{
                $equipo->marca =$input['marca'];
                $equipo->modelo =$input['modelo'];
                $equipo->numero_serie =$input['numero_serie'];
                $equipo->departamento =$input['departamento'];
                $equipo->id_equipo =$input['id_equipo'];
                $equipo->estado =$input['estado'];
                $equipo->ip =$input['ip'];
                $equipo->mac =$input['mac'];
                $equipo->tipo_cartucho =$input['tipo_cartucho'];
            }
           
          //  $equipo['status']=1;
          //  $equipo['create_at']=date('Y-m-d');
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $input = $request->all();
        try{
            $equipo = TiInventarioEquipo::where('id','=',$input['id'])->first();
            $equipo->status = 2;
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
        //
    }
}
