





<?php $__env->startSection('title', 'Plataforma De Capacitación'); ?>



<?php $__env->startSection('content_header'); ?>

       <script src="<?php echo e(URL::asset('plugins/DataTables/datatables.min.js')); ?>"></script>

    <div class="row">

        <div class="col-sm-10">

            <h1 class="m-0 text-dark">Materiales</h1>

        </div>

        <div class="col-sm-2 d-flex justify-content-end align-items-center text-center">

            <a href="<?php echo e(route('materiales.create',[$idCurso])); ?>" class="btn btn-primary text-center d-flex justify-content-center align-items-center" style="width:35px;height:35px;"><i class="fa fa-plus"></i></a>

        </div>

        <div class="col-sm-12">

            <nav aria-label="breadcrumb">

                <ol class="breadcrumb">

                    <li class="breadcrumb-item"><a href="<?php echo e(route('cursos.index')); ?>">Cursos</a></li>

                    <li class="breadcrumb-item active" aria-current="page">Curso: <?php echo e($curso->nombre); ?></li>

                </ol>

            </nav>

        </div>

    </div>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="flex-container">

                        <div class="row" style="">

                            

                            <div class="col-sm-12">

                                <div class="">

                                    <?php if($materiales->count()>0): ?>

                                        <table class="table table-striped table-bordered w-100">

                                            <thead>

                                                <tr>

                                                 

                                                  

                                                    <th>Nombre</th>

                                                    <th>Tipo</th>

                                                    <th>Visibilidad</th>

                                                    <th style="width:75px;">Acciones</th>

                                                </tr>

                                            </thead>

                                            <tbody>

                                                <?php $__currentLoopData = $materiales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nivel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <tr>

                                                        

                                                  

                                                        <td>

                                                            <?php echo e($nivel->nombre); ?>

                                                        </td>

                                                        <td>

                                                            <?php if($nivel->tipo==0): ?>

                                                                Imagen

                                                            <?php endif; ?>

                                                            <?php if($nivel->tipo==1): ?>

                                                                Documento

                                                            <?php endif; ?>

                                                            <?php if($nivel->tipo==2): ?>

                                                                Video One Drive

                                                            <?php endif; ?>

                                                            <?php if($nivel->tipo==3): ?>

                                                                Iframe

                                                            <?php endif; ?>



                                                        </td>

                                                        <td>

                                                            <div class="toggle-button-cover">

                                                                    <div class="button-cover">

                                                                        <div class="button r" id="button-1">

                                                                        <input type="checkbox" onclick="changeStatus(event,'<?php echo e($nivel->idMaterial); ?>',<?php echo e($nivel->visibilidad); ?>)" class="checkbox" <?php if($nivel->visibilidad==0){echo "checked";}?>/>

                                                                        <div class="knobs"></div>

                                                                        <div class="layer"></div>

                                                                        </div>

                                                                    </div>

                                                                </div>

                                                        </td>

                                                        <td style="width:125px;" >

                                                            <div class="d-flex">

                                                            <a href="<?php echo e(route('materiales.edit',[$idCurso,$nivel])); ?>"  class="btn btn-warning text-white" style="margin-left:5px;">

                                                                        <i class="fa fa-edit"></i>

                                                            </a>

                                                            

                                                            <form action='<?php echo e(route("materiales.destroy", [$nivel])); ?>' method="post" onsubmit="return validate(event,this,<?php echo e($nivel->idMaterial); ?>,1)">

                                                                    <?php echo method_field("delete"); ?>

                                                                    <?php echo csrf_field(); ?>

                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">

                                                                        <i class="fa fa-trash"></i>

                                                                    </button>

                                                                </form>

                                                            </div>

                                                           

                                                        </td>

                                                           

                                                        </td>

                                                    </tr>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </tbody>

                                        </table>    

                                    <?php endif; ?>

                                    <?php if($materiales->count()==0): ?>

                                        <h2>No hay materiales</h2>

                                    <?php endif; ?>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <?php $route2 = route("materiales.index",[$idCurso]);?>

    <input type="hidden" value="<?php echo e($route2); ?>" id="route" />

    <input type="hidden" value="<?php echo e($idCurso); ?>" id="idCurso" />

    <script src="<?php echo e(URL::asset('js/materiales/list.js')); ?>"></script>   

<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intranetmex/pretorian.intranetmex.com/plataforma/resources/views/materiales/index.blade.php ENDPATH**/ ?>