@extends('adminlte::page')





@section('title', 'Plataforma De Capacitación')



@section('content_header')

       <script src="{{ URL::asset('plugins/DataTables/datatables.min.js'); }}"></script>

    <div class="row">

        <div class="col-sm-10">

            <h1 class="m-0 text-dark">Usuarios</h1>

        </div>

        <div class="col-sm-2 d-flex justify-content-end align-items-center text-center">

            <a href="{{route('usuarios.create');}}" class="btn btn-primary text-center d-flex justify-content-center align-items-center" style="width:35px;height:35px;"><i class="fa fa-plus"></i></a>

        </div>

    </div>

@stop



@section('content')



    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="flex-container">

                        <div class="row" style="">

                            

                            <div class="col-sm-12">

                                <div class="">

                                    @if($usuarios->count()>0)

                                        <table class="table table-striped table-bordered w-100">

                                            <thead>

                                                <tr>

                                                 

                                                 

                                                    <th>Email</th>

                                                    <th>Tipo</th>

                                                    <th>Estado</th>

                                                    <th style="width:75px;">Acciones</th>

                                                </tr>

                                            </thead>

                                            <tbody>

                                                @foreach($usuarios as $nivel)

                                                    <tr>

                                                        

                                                        

                                                        <td>

                                                            {{$nivel->name}}

                                                        </td>

                                                        <td>

                                                            @if($nivel->typeuser==0)

                                                                Administrador

                                                            @endif

                                                            @if($nivel->typeuser==1)

                                                                Colaborador

                                                            @endif

                                                        </td>

                                                        <td>

                                                            <div class="toggle-button-cover">

                                                                    <div class="button-cover">

                                                                        <div class="button r" id="button-1">

                                                                        <input type="checkbox" onclick="changeStatus(event,'{{$nivel->IdUser}}',{{$nivel->isEnabled})" class="checkbox" <?php if($nivel->isEnabled==0){echo "checked";}?>/>

                                                                        <div class="knobs"></div>

                                                                        <div class="layer"></div>

                                                                        </div>

                                                                    </div>

                                                                </div>

                                                        </td>

                                                        <td style="width:125px;" >

                                                            <div class="d-flex">

                                                            <a href="{{route('usuarios.edit',[$nivel])}}"  class="btn btn-warning text-white" style="margin-left:5px;">

                                                                        <i class="fa fa-edit"></i>

                                                            </a>

                                                            @if($nivel->id!=1)

                                                            <form action='{{route("usuarios.destroy", [$nivel])}}' method="post" onsubmit="return validate(event,this,{{$nivel->IdUser}},1)">

                                                                    @method("delete")

                                                                    @csrf

                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">

                                                                        <i class="fa fa-trash"></i>

                                                                    </button>

                                                                </form>

                                                            </div>

                                                            @endif

                                                        </td>

                                                           

                                                        </td>

                                                    </tr>

                                                @endforeach

                                            </tbody>

                                        </table>    

                                    @endif

                                    @if($usuarios->count()==0)

                                        <h2>No hay usuarios</h2>

                                    @endif

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <?php $route2 = route("usuarios.index");?>

    <input type="hidden" value="{{$route2}}" id="route" />



    <script src="{{ URL::asset('js/usuarios/list.js'); }}"></script>   

@stop

