@extends('adminlte::page')



@section('title', 'Plataforma De Capacitación')



@section('content_header')

    <h1 class="m-0 text-dark">Materiales</h1>



    <link rel="stylesheet" href="{{ URL::asset('plugins/sceditor/minified/themes/default.min.css'); }}" />



<script src="{{ URL::asset('plugins/sceditor/minified/sceditor.min.js'); }}"></script>

<script src="{{ URL::asset('plugins/sceditor/minified/icons/monocons.js'); }}"></script>



<div class="col-sm-12">

            <nav aria-label="breadcrumb">

                <ol class="breadcrumb">

                    <li class="breadcrumb-item"><a href="{{route('cursos.index')}}">Cursos</a></li>

                    <li class="breadcrumb-item" ><a href="{{route('materiales.index',[$idCurso])}}">Curso: {{$curso->nombre}}</a></li>

                    <li class="breadcrumb-item active" aria-current="page">Agregar Material</li>

                </ol>

            </nav>

        </div>

@stop



@section('content')

    <div class="row">

        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    <div class="flex-container">

                        <form onsubmit="return save(event)">

                            <div class="row" style="">

                                

                                

                                <div class="col-sm-12">

                                    <label class="w-100 font-weight-bold">Nombre</label>

                                    <input type="text" id="nombre" class="form-control w-100" required/>

                                    <span class="text-danger font-weight-bold"></span>

                                </div>

                                <div class="col-sm-12">

                                    <label class="w-100 font-weight-bold">Descripcion</label>

                                    <textarea id="descripcion" class="form-control w-100" style="min-height:300px" required></textarea>

                                    <span class="text-danger font-weight-bold"></span>

                                </div>

                               

                                @if($_SESSION["isAdmin"]==1)

                                <input type="hidden" id="empresa" value="{{$_SESSION['empresa']->idEmpresa}}"/>

                               @endif

                               

                                

                               <div class="col-sm-12">

                                    <label class="w-100 font-weight-bold">Tipo</label>

                                    <select id="tipo" class="form-control w-100 form-select" onchange="changeTypeFile()" required>

                                        <option value="0">Imagen</option>

                                        <option value="1">Documento</option>

                                        <option value="2">Video One Drive</option>

                                        <option value="3">Iframe</option>
                                        <option value="4">URL</option>
                                    </select>

                                    <span class="text-danger font-weight-bold"></span>

                                </div>


<div class="col-sm-12" id="div-url">

                                    <label class="w-100 font-weight-bold">URL</label>

                                    <input type="text" id="url" class="form-control w-100" />

                                    <span class="text-danger font-weight-bold"></span>

                                </div>
                                <div class="col-sm-12" id="div-iframe">

                                    <label class="w-100 font-weight-bold">Iframe</label>

                                    <input type="text" id="iframe" class="form-control w-100" />

                                    <span class="text-danger font-weight-bold"></span>

                                </div>

                                <div class="col-sm-12"  id="div-video">

                                    <label class="w-100 font-weight-bold">Video One Drive</label>

                                    <input type="text" id="video" class="form-control w-100" />

                                    <span class="text-danger font-weight-bold"></span>

                                </div>

                                <div class="col-sm-4"  id="div-tiempo">

                                    <label class="w-100 font-weight-bold">Minutos</label>

                                    <input type="number" id="minutos" class="form-control w-100" value="0"/>

                                    <span class="text-danger font-weight-bold"></span>

                                </div>

                                <div class="col-sm-4"  id="div-tiempo2">

                                    <label class="w-100 font-weight-bold">Segundos</label>

                                    <input type="number" id="segundos" class="form-control w-100" value="0"/>

                                    <span class="text-danger font-weight-bold"></span>

                                </div>

                                <div class="col-sm-12"  id="div-archivo">

                                    <label class="w-100 font-weight-bold">Archivo</label>

                                    <input type="file" id="archivo" class="form-control w-100"  />

                                    <span class="text-danger font-weight-bold"></span>

                                </div>

                                <input type="hidden" value="{{$idCurso}}" id="idCurso" />

                                <div class="col-sm-12  d-flex justify-content-end" style="margin-top:10px">

                                    <input type="hidden"  id="ip"/>  

                                    <button type="submit" class="btn btn-primary">Guardar</button>

                                </div>

                            </div>

                        </form>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <?php $route2 = route("materiales.index",[$idCurso]);?>

<input type="hidden" value="{{$route2}}" id="route" />

<input type="hidden" value="{{$idCurso}}" id="idCurso" />

<script src="{{ URL::asset('js/materiales/add.js'); }}?v={{rand()}}"></script>  





@stop

