<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class User
 * 
 * @property int $IdUser
 * @property string $name
 * @property string $password
 * @property int $typeuser
 * @property int $isFirst
 * @property int $isEnabled
 * 
 * @property Collection|Empleado[] $empleados
 *
 * @package App\Models
 */
class User extends Model
{
	protected $table = 'users';
	protected $primaryKey = 'IdUser';
	public $timestamps = false;

	protected $casts = [
		'typeuser' => 'int',
		'isFirst' => 'int',
		'isEnabled' => 'int'
	];

	protected $hidden = [
		'password'
	];

	protected $fillable = [
		'name',
		'password',
		'typeuser',
		'isFirst',
		'isEnabled'
	];

	public function empleados()
	{
		return $this->hasMany(Empleado::class, 'idUser');
	}
}
