<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProgresoEmpleado
 * 
 * @property int $idCurso
 * @property int $idEmpleado
 * @property int $itemsVistos
 * @property Carbon $creado
 * 
 * @property Empleado $empleado
 * @property Curso $curso
 *
 * @package App\Models
 */
class ProgresoEmpleado extends Model
{
	protected $table = 'progreso_empleados';
	protected $primaryKey = "idProgreso";
	public $incrementing = false;
	public $timestamps = false;

	protected $casts = [
		'idCurso' => 'int',
		'idEmpleado' => 'int',
		'itemsVistos' => 'int',
		'creado' => 'datetime'
	];

	protected $fillable = [
		'idCurso',
		'idEmpleado',
		'itemsVistos',
		'creado'
	];

	public function empleado()
	{
		return $this->belongsTo(Empleado::class, 'idEmpleado');
	}

	public function curso()
	{
		return $this->belongsTo(Curso::class, 'idCurso');
	}
}
