$(document).ready(function () {

  if ($("table").length == 0) {

    $(".spin").css("display", "none");

  }

  $("#table_").DataTable({

    destroy: true,

    language: {

      url: "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json",

    },

    responsive: true,

    order: [],

    columnDefs: [

      { width: "50px", sortable: false, targets: 3 },

      //  { "width": "50px","sortable":false, "targets": 2 }

    ],

    //dom: 'Bfrtip',

    buttons: [],

    initComplete: function () {

      $(".spin").css("display", "none");

    },

  });
  if($("#isWatching").val()==0){

    $("#table_status").remove();
  
    return;
  }else{
    watchTable();
    $("#table_").remove();
  }
 

});

const watchTable = ()=>{
  $.ajaxSetup({

    headers: {

        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

    }

});

  $.ajax({

    type:'POST',

    url:"./admin/api/usuarios.php?action=watching",

    data:{},

    processData: false,

    contentType: false,

    success:function(data){

        //console.log(data);
        let json = JSON.parse(data);
       // console.log(json);
        if(json.cantidadUsuarios!=0){
          setTableUsuarios(json.usuarios);
        }
        if(contadorInicial==0){
          contadorInicial++;
          setTableUsuarios(json.usuarios);
        }
       // setTableUsuarios(json.usuarios);
        setTimeout(() => {
          console.log("Actualizando tabla");
          watchTable();
        }, 30000);

    },

    error:function(data){

        console.log(data);

        $(".spin").css('display','none');

        alertError("Error en el servidor");

    }



 });
}
const downloadPDF = ()=>{
  $.ajaxSetup({
      headers: {

        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

      }

  });

  $.ajax({

  type:'POST',

  url:"./admin/api/usuarios.php?action=watching",

  data:{},

  processData: false,

  contentType: false,

  success:function(data){
    let json = JSON.parse(data);
    console.log("PDF",json.usuarios);
    documentPDF(json.usuarios);
  },

    error:function(data){

        console.log(data);

        $(".spin").css('display','none');

        alertError("Error en el servidor");

    }



  });
}

function documentPDF(datos) {
  let date = new Date();

  var doc = new jsPDF({ orientation: "p", unit: "mm", format: "a4" });
  var pageHeight =
      doc.internal.pageSize.height || doc.internal.pageSize.getHeight();
  var pageWidth =
      doc.internal.pageSize.width || doc.internal.pageSize.getWidth();
  let text = "";
  let indexY = 10;
  let maxLineWidth = pageWidth - 20;

  let indexX = 10;
  doc.setFont("times", "bold");
  doc.setFontSize(14);
  text = "Reporte de usuarios "+getDateComplete(new Date());
  let textPostion = this.center(doc, text);
  doc.text(text, textPostion, indexY);

  doc.setFont("times", "normal");
  doc.setFontSize(12);
  let data = customDataJSPDF(datos);
  doc.autoTable({
      head: getHeaders(),
      styles: { fontSize: 11 },
      body: data,
      margin: { left: 20, right: 20 },
      theme: 'striped',
      startY: 30,
      linWidth: 0,
      lineColor: [255, 255, 255],
      columnStyles: {
       // 0: {cellWidth: 100},
       // 1: {cellWidth: 80},
       1:{fontSize:9},
        2: {cellWidth: 20},
        3: {cellWidth: 30},
        // etc
        },
      didDrawCell: (data) => {
        //console.log(data.column.index)
      },
      headStyles: {
        fillColor: [61, 61, 61],
        textColor: [255, 255, 255],
      },
    });
  console.log("Data", data);
  doc = addFooters(doc);
  let image = new Image();
  image.src = $("#logext").attr("src");
 
  /*image.onload = function () {
       doc.setPage(1);
      doc.addImage(image, "PNG", pageWidth - 60, 2, 45, 25);
      if(rango==0){
          let valor = "";
         
          doc.save("Reporte General "+valor);
      }else{
          let valor = "";
         
          doc.save("Reporte "+valor+"_"+inicio+" - "+final);
      }*/ 
      doc.save("Reporte de usuarios");
     
      //dataurlnewwindow
  //};
}
function getHeaders(){

  return [[{content:"Nombre"},{content:"Usuario"},{content:"Estado"},{content:"Ultima Actividad"}]];
}
function center(doc, text) {
  var textWidth =
      (doc.getStringUnitWidth(text) * doc.internal.getFontSize()) /
      doc.internal.scaleFactor;
  var textOffset = (doc.internal.pageSize.width - textWidth) / 2;
  return textOffset;
}
function addFooters(doc) {
  const pageCount = doc.internal.getNumberOfPages();
  doc.setFont("helvetica", "italic");
  doc.setFontSize(8);
  for (var i = 1; i <= pageCount; i++) {
      doc.setPage(i);
      var pageHeight =
          doc.internal.pageSize.height || doc.internal.pageSize.getHeight();
      var pageWidth =
          doc.internal.pageSize.width || doc.internal.pageSize.getWidth();
      /*doc.text(
      'Página ' + String(i) + ' de ' + String(pageCount),
      pageWidth / 2-8,
      pageHeight - 5,
      {
        align: 'center',
      }
    );*/

      
  }
  return doc;
}
function customDataJSPDF(data) {
  let converted_data = [];

  for (let i = 0; i < data.length; i++) {
    let data_simplex = [
      {
          content: data[i].nombre, // data.fases[i].nombre,
          styles: { halign: "left", lineWidth: 0, fontStyle: "normal" },
      },
      {
          content:data[i].email, // data.fases[i].nombre,
          styles: { halign: "left", lineWidth: 0, fontStyle: "normal" },
      },
      {
        content:data[i].isActive==1?"Activo":"Inactivo", // data.fases[i].nombre,
        styles: { halign: "left", lineWidth: 0, fontStyle: "normal", textColor: data[i].isActive==1?"#198754":"#dc3545"},
    },
    {
      content:data[i].ultima, // data.fases[i].nombre,
      styles: { halign: "left", lineWidth: 0, fontStyle: "normal" },
  },
  ];
  converted_data.push(data_simplex);
  }

  return converted_data;
}
let contadorInicial=0;
const forceUpdateTable = ()=>{
  $.ajaxSetup({

    headers: {

        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

    }

});

  $.ajax({

    type:'POST',

    url:"./admin/api/usuarios.php?action=watching",

    data:{},

    processData: false,

    contentType: false,

    success:function(data){

        //console.log(data);
        let json = JSON.parse(data);
       // console.log(json);
         setTableUsuarios(json.usuarios);
        
       // setTableUsuarios(json.usuarios);
      

    },

    error:function(data){

        console.log(data);

        $(".spin").css('display','none');

        alertError("Error en el servidor");

    }



 });
}
const setTableUsuarios = (datas)=>{
  //console.log(datas);
 
  $("#table_status").DataTable({

    destroy: true,

    language: {

      url: "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json",

    },
    "processing": true,
    responsive: true,
    data:datas,
    
    columns: [
      {data: 'sistema'},
      {data: 'nombre',
        render: function (data, type, row) {
          return '<img src="/panel/assets/usuarios/'+row.imagen+'" style="width:35px;height:30px;margin-right:5px"/>'+row.nombre
        }
      },
      {data: 'email'},
      {data: 'isActive',
          render:function(data,type,row){
            return row.isActive==1?"<div class='bg-success text-white text-center font-weight-bold' style='padding:3px;border-radius:50px;'>Activo</div>":"<div class='bg-danger text-white text-center font-weight-bold' style='padding:3px;border-radius:50px;'>Inactivo</div>";
          }
      },
      {data: 'idUsuario',
        render: function (data, type, row) {
         
          if($("#isAdmin").val()<=1){
            return '<a href="/panel/editar.php?id='+row.idUsuario+'" class="btn btn-warning text-white"><i class="fa fa-edit"></i></a>'+
                '<button style="margin-left:5px" onclick="removeItem('+row.idUsuario+')" class="btn btn-danger text-white"><i class="fa fa-trash"></i></button>';
           // return row.idUsuario;
          }else{
            return "";
          }
         // return '<button type="button" class="btn btn-info text-white" onclick="copy(\''+row.imagen+'\')"><span><i class="fa fa-clipboard"></i></span></button>';
        }
      }
    ],
    order: [],

    columnDefs: [

      { width: "90px", sortable: false, targets: 4 },

      //  { "width": "50px","sortable":false, "targets": 2 }

    ],

    //dom: 'Bfrtip',

    buttons: [],

    initComplete: function () {

      $(".spin").css("display", "none");

    },

  });
}

const removeItem = (id) => {

  confirmacionEliminar(

    "¿Desea eliminar el usuario?",

    "Aceptar",

    "Cancelar",

    function (response) {

      if (response) {

        let form = new FormData();

        $.ajaxSetup({

          headers: {

            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),

          },

        });

        console.log(id);

        form.append("id", id);

        $.ajax({

          type: "POST",

          url: "./admin/api/usuarios.php?action=delete",

          data: form,

          processData: false,

          contentType: false,

          success: function (data) {

            console.log(data);

            $(".spin").css("display", "none");

            let json = JSON.parse(data);

            console.log(json);

            if (json) {

              let rsp = alertTimeCorrect(

                "Excelente",

                "Usuario eliminado",

                function (response) {

                  window.location = window.location.href;

                }

              );

            } else {

              alertError("Error", "No se eliminó el usuario");

            }

          },

          error: function (data) {

            console.log(data);

            $(".spin").css("display", "none");

            alertError("Error en el servidor");

          },

        });

      }

    }

  );

};



const syncUsers = () => {

  confirmacionEliminar(

    "¿Desea sincronizar las base de datos?",

    "Aceptar",

    "Cancelar",

    function (response) {

      if (response) {

        let form = new FormData();

        $.ajaxSetup({

          headers: {

            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),

          },

        });

        

        $.ajax({

          type: "POST",

          url: "./admin/api/usuarios.php?action=sync",

          data: form,

          processData: false,

          contentType: false,

          success: function (data) {

            console.log(data);

            $(".spin").css("display", "none");

            let json = JSON.parse(data);

            console.log(json);

            if (json) {

              let rsp = alertTimeCorrect(

                "Excelente",

                "Base de datos sincronizadas",

                function (response) {

                  window.location.reload();

                }

              );

            } else {

              alertError("Error", "No se sincronizaron las base de datos");

            }

          },

          error: function (data) {

            console.log(data);

            $(".spin").css("display", "none");

            alertError("Error en el servidor");

          },

        });

      }

    }

  );

};

