<?php

require_once __DIR__."/../config/globals.php";



require_once  __DIR__."/../repository/UsuarioRepository.php";

require_once  __DIR__."/../repository/UsuarioAgendaRepository.php";

require_once  __DIR__."/../repository/UsuarioCapacitacionRepository.php";

require_once  __DIR__."/../repository/UsuarioChecadorRepository.php";

require_once  __DIR__."/../repository/UsuarioHelpDeskRepository.php";

require_once  __DIR__."/../repository/UsuarioHelpDeskDisenioRepository.php";

require_once  __DIR__."/Controller.php";





class UsuarioController extends Controller{

    private $usuarioRepo;

    private $usuarioAgendaRepo;

    private $usuarioCapacitacionRepo;

    private $usuarioChecadorRepository;

    private $usuarioHelpDeskRepository;
    
    private $usuarioHelpDeskDisenioRepository;

    public function __construct()

    {

       $this->usuarioRepo = new UsuarioRepository();    

       $this->usuarioAgendaRepo = new UsuarioAgendaRepository();    

       $this->usuarioCapacitacionRepo = new UsuarioCapacitacionRepository();   

       $this->usuarioChecadorRepository = new UsuarioChecadorRepository();    

       $this->usuarioHelpDeskRepository = new UsuarioHelpDeskRepository();   

        $this->usuarioHelpDeskDisenioRepository = new UsuarioHelpDeskDisenioRepository();

    }

    public function list(){

       

     

      

       

        $data=$this->usuarioRepo->list();

		//$this->watching();

        return $data;

    }

    
    public function watching(){
        $data=$this->usuarioRepo->listActive();
        $cantidadUsuarios = 0;
        foreach($data as $usuario){
            $id =  $usuario->id;
            date_default_timezone_set('America/Mexico_City');
            $fecha = date('Y-m-d h:i:s');
            $month = date('m');
            $day = date('d');
            $year = date('Y');
            $this->actividadController = new ActividadRepository();
            $actividades = $this->actividadController->actividadUsuario($id,$month,$year,$day);
            
            if(!empty($actividades)){
                $actividad = $actividades[0];
                $fecha = $actividad->fecha;
                $fechaF = date_create($fecha);
                $fecha_FF = date_format($fechaF,"h:i:s d-m-Y");
                $fechaA = date_create();
                $diferencia = $fechaA->diff($fechaF);
                //echo $diferencia->i." ".json_encode($diferencia);
                if($diferencia->days==0 && $diferencia->i<=2){
                    $this->actividadController->actualizarUsuario($id,1);
                }else{
                    $this->actividadController->actualizarUsuario($id,0);
                    $cantidadUsuarios++;
                }
            }else{
                $this->actividadController->actualizarUsuario($id,0);
                $cantidadUsuarios++;
            }
           
        }
        $datas=$this->usuarioRepo->list();
        $usuarios=[];
        //$usuarios=$data;
        foreach($datas as $usuario){
            date_default_timezone_set('America/Mexico_City');
            $fecha = date('Y-m-d h:i:s');
            $month = date('m');
            $day = date('d');
            $year = date('Y');
            $id =  $usuario->id;
            $ultima="";
            $this->actividadController = new ActividadRepository();
            $actividades = $this->actividadController->actividadUsuario($id,$month,$year,$day);
            if(empty($actividades)){
                $ultima="Indeterminado";
            }else{
                $actividad= $actividades[0];
                $ultima=date_format(date_create($actividad->fecha),"h:i");
            }
            $usuarios[]=[
                "sistema"=>$usuario->sistema,
                "nombre"=>$usuario->nombre." ".$usuario->apellidos,
                "email"=>$usuario->email,
                "isActive"=>$usuario->isActive,
                "idUsuario"=>$usuario->id,
                "imagen"=>$usuario->imagen,
                "ultima"=>$ultima
            ];
        }
        $data = [
            "cantidadUsuarios"=> $cantidadUsuarios,
            "usuarios"=>$usuarios
        ];
        echo json_encode($data);
    }

    public function listaDepartamentos(){

       

     

      

        $data=$this->usuarioChecadorRepository->departamentos();

       



		

        return $data;

    }

    public function listaEmpresasPanel(){
        $data=$this->usuarioRepo->listActivos();
		
        return $data;
    }
    public function listaEmpresas(){

       

     

      

        $data=$this->usuarioCapacitacionRepo->empresas();

       



		

        return $data;

    }

    public function crearUsuario($usuario){

        //echo json_encode($usuario);

        

        $this->usuarioRepo->insert($usuario);



        //Insertar en otras BDS

        $usuariosGlobal=$this->usuarioRepo->listNativos();

        $usuariosGlobal2=$this->usuarioRepo->listNativos();

        $usuariosGlobal3=$this->usuarioRepo->listNativos();

        $usuariosGlobal4=$this->usuarioRepo->listNativos();
        $usuariosGlobal5=$this->usuarioRepo->listNativos();

        $this->syncToLaravel("Agenda",$usuariosGlobal);

        $this->syncToLaravel("Plataforma",$usuariosGlobal2);

        $this->syncToHelpDesk("HelpDesk",$usuariosGlobal3);

        $this->syncToChecador("Checador",$usuariosGlobal4);


        $this->syncToHelpDeskDisenio("Help Desk Disenio",$usuariosGlobal5);
        echo 'true';

    }

    

    public function editarUsuario($usuario){

        //echo json_encode($usuario);

        $usuarioG = $this->usuarioRepo->usuarioPorId($usuario["id"]);

        if(empty($usuario['password'])){
          
            $usuario["password"] = $usuarioG->password;

            

        }

        if($usuario['imagen']=='false'){
            $usuario['imagen']= $usuarioG->imagen;
        }
        $this->usuarioRepo->update($usuario);



        //Insertar en otras BDS



        $usuariosGlobal=$this->usuarioRepo->listNativos();

        $usuariosGlobal2=$this->usuarioRepo->listNativos();

        $usuariosGlobal3=$this->usuarioRepo->listNativos();

        $usuariosGlobal4=$this->usuarioRepo->listNativos();
             $usuariosGlobal5=$this->usuarioRepo->listNativos();

       // echo json_encode($usuariosGlobal);

        $this->syncToLaravel("Agenda",$usuariosGlobal);

        $this->syncToLaravel("Plataforma",$usuariosGlobal2);

        $this->syncToHelpDesk("HelpDesk",$usuariosGlobal3);

        $this->syncToChecador("Checador",$usuariosGlobal4);

   $this->syncToHelpDeskDisenio("Help Desk Disenio",$usuariosGlobal5);



        echo 'true';

    }



    public function usuarioPorId($id){

        $usuario=$this->usuarioRepo->usuarioPorId($id);



        return $usuario;

    }

    public function eliminarUsuario($id){

        $usuario=$this->usuarioRepo->eliminarUsuario($id);
        
        error_log('Usuario eliminado =>'.json_encode($usuario));

        $usuariosDeletedGlobal=$this->usuarioRepo->listDeleted();

        $this->syncDeletedLaravel($usuariosDeletedGlobal);

        echo 'true';

    }

    



    public function syncUsers(){

        $usuariosGlobal=$this->usuarioRepo->listNativos();



        $usuariosAgenda=$this->usuarioAgendaRepo->list();

        $usuariosCapacitacion=$this->usuarioCapacitacionRepo->list();



        $usuariosHelpDesk=$this->usuarioHelpDeskRepository->list();



        $usuariosChecador=$this->usuarioChecadorRepository->list();



        /*echo json_encode($usuariosAgenda);

        echo "<br />";

        echo "<br />";

        echo json_encode($usuariosCapacitacion);

        echo "<br />";

        echo "<br />";



        echo json_encode($usuariosHelpDesk);

        echo "<br />";

        echo "<br />";



        echo json_encode($usuariosChecador);

        echo "<br />";

        echo "<br />";*/



        //echo "Sincronizar otras base de datos<br />";

        $this->syncLaravel($usuariosAgenda,"Agenda");

        $this->syncLaravel($usuariosCapacitacion,"Plataforma");

        $this->syncHelpDesk($usuariosHelpDesk,"HelpDesk");

        $this->syncChecador($usuariosChecador,"Checador");


   $this->syncToHelpDeskDisenio("Help Desk Disenio",$usuariosGlobal5);


        //echo "Sincronizar base de datos centralizada<br />";

        $usuariosGlobal2=$this->usuarioRepo->listNativos();

        $usuariosGlobal3=$this->usuarioRepo->listNativos();

        $usuariosGlobal4=$this->usuarioRepo->listNativos();

        $this->syncToLaravel("Agenda",$usuariosGlobal);

        $this->syncToLaravel("Plataforma",$usuariosGlobal2);



        $this->syncToHelpDesk("HelpDesk",$usuariosGlobal3);

        $this->syncToChecador("Checador",$usuariosGlobal4);





        //echo "Eliminar datos usuarios eliminados centralizado<br />";

        $usuariosDeletedGlobal=$this->usuarioRepo->listDeleted();

        $this->syncDeletedLaravel($usuariosDeletedGlobal);



        echo 'true';

        

    }

    public function syncDeletedLaravel($usuarios){

        foreach ($usuarios as $key => $usuario) {

            //DELETED

           // echo "Usuario eliminado:$usuario->id<br><br>";

            $this->usuarioAgendaRepo->deletedUser($usuario->email);

            $this->usuarioCapacitacionRepo->deletedUser($usuario->email);

            $this->usuarioHelpDeskRepository->deletedUser($usuario->email);

            $this->usuarioChecadorRepository->deletedUser($usuario->email);



            $this->usuarioRepo->deletedUser($usuario->id);

        }

    }



    

    public function syncChecador($usuarios,$sistema){

        foreach ($usuarios as $key => $usuario) {

            if(empty($usuario->email)){

                   $usuario->email = $usuario->login;

            }

            $usuario->name=$usuario->email;

            $usuario->password=$usuario->password;

            

            $search  = $this->usuarioRepo->getUsuarioEmailYPasswordChecador($usuario);

         

            $usuario->sistema=$sistema;

            $usuario->nombre=  $usuario->nombre;

            $usuario->apellidos=  $usuario->apellidos;

            

            $usuario->email= $usuario->email;

            $usuario->imagen="placeholder.jpg";

           $usuario->creado=date('Y-m-d');

            $usuario->modificado=date('Y-m-d');

            $usuario->eliminado=date('Y-m-d');

            $usuario->nativo=2;

            $usuario->estado = $usuario->estado;

            $usuario->tipoUsuario = $usuario->idtipousuario;

        

            $usuario->sistemaA="tipoUsuarioChecador";

            if(!empty($search)){

                //update

               //echo "Exist<br><br>";



                $usuario->id = $search[0]->id;

                

                $this->usuarioRepo->updateFromChecadorSync($usuario);

            }else{

               // echo " Not Exist<br><br>";

             

               

                $this->usuarioRepo->insertFromChecadorSync($usuario);

                //insert

            }

        }

    }

    public function syncHelpDesk($usuarios,$sistema){

        foreach ($usuarios as $key => $usuario) {

            $usuario->name=$usuario->usu_correo;

            $usuario->password=$usuario->usu_pass;

            $search  = $this->usuarioRepo->getUsuarioEmailYPassword($usuario);

         

            $usuario->sistema=$sistema;

            $usuario->nombre=  $usuario->usu_nom;

            $usuario->apellidos=  $usuario->usu_ape;

            

            $usuario->email= $usuario->usu_correo;

            $usuario->imagen="placeholder.jpg";

           $usuario->creado=date('Y-m-d');

            $usuario->modificado=date('Y-m-d');

            $usuario->eliminado=date('Y-m-d');

            $usuario->nativo=2;

            $usuario->estado = $usuario->est;

            $usuario->tipoUsuario = $usuario->rol_id;

           

            $usuario->sistemaA="tipoUsuariohelpDesk";

            if(!empty($search)){

                //update

               //echo "Exist<br><br>";



                $usuario->id = $search[0]->id;

             

                $this->usuarioRepo->updateFromLaravelSync($usuario);

            }else{

               // echo " Not Exist<br><br>";



               

                $this->usuarioRepo->insertFromLaravelSync($usuario);

                //insert

            }

        }

    }

    
public function syncToHelpDeskDisenio($sistema,$usuarios){

        foreach ($usuarios as $key => $usuario) {

            $usuario->tipoUsuario = $usuario->tipoUsuarioDisenio;

            $search  = $this->usuarioHelpDeskDisenioRepository->getUsuarioEmailYPassword($usuario);

            if(!empty($search)){

                //update
                if($usuario->email=="@gmail.com"){
               //     echo "Exist HelpDesk <br><br>";
                }
               



                $usuario->id = $search[0]->usu_id;

             

                $this->usuarioHelpDeskDisenioRepository->updateToLaravelSync($usuario);

            }else{
                if($usuario->email=="@gmail.com"){
                //    echo " Not Exist HelpDesk<br><br>";
                }
              

               

                

                $this->usuarioHelpDeskDisenioRepository->insertToLaravelSync($usuario);

                //insert

            }

        }

    }


    

    public function syncToChecador($sistema,$usuarios){

       //echo json_encode($usuarios);

        foreach ($usuarios as $key => $usuario) {

            //echo "ID =>",$usuario->id;

            //$usuario->tipoUsuario = $usuario->tipoUsuarioChecador;

            $search  = $this->usuarioChecadorRepository->getUsuarioEmailYPassword($usuario);

            if(!empty($search)){

                //update

                //echo "Exist Checador <br><br>".json_encode($search);

               // echo json_encode($search);

                $usuario->id = $search[0]->idusuario;

                if( $usuario->tipoUsuarioChecador==0){

                    $usuario->tipoUsuario=1;

                }else{
                    $usuario->tipoUsuario=0;
                }

                $usuario->password = $usuario->passwordChecador;

                $this->usuarioChecadorRepository->updateToLaravelSync($usuario);

            }else{

               //echo " Not Exist Checador<br><br>";

               

               if( $usuario->tipoUsuarioChecador==0){

                $usuario->tipoUsuario=1;

            }else{
                $usuario->tipoUsuario=0;
            }

                $usuario->password = $usuario->passwordChecador;

                $this->usuarioChecadorRepository->insertToLaravelSync($usuario);

                //insert

            }

        }

    }



    public function syncToHelpDesk($sistema,$usuarios){

        foreach ($usuarios as $key => $usuario) {

            $usuario->tipoUsuario = $usuario->tipoUsuarioAgenda;

            $search  = $this->usuarioHelpDeskRepository->getUsuarioEmailYPassword($usuario);

            if(!empty($search)){

                //update

               // echo "Exist HelpDesk <br><br>";



                $usuario->id = $search[0]->usu_id;

             

                $this->usuarioHelpDeskRepository->updateToLaravelSync($usuario);

            }else{

              // echo " Not Exist HelpDesk<br><br>";

               

                

                $this->usuarioHelpDeskRepository->insertToLaravelSync($usuario);

                //insert

            }

        }

    }

    

    public function syncToLaravel($sistema,$usuarios){

        foreach ($usuarios as $key => $usuario) {

            if($sistema=="Agenda"){

                 $usuario->tipoUsuario = $usuario->tipoUsuarioAgenda;

                $search  = $this->usuarioAgendaRepo->getUsuarioEmailYPassword($usuario);

                if(!empty($search)){

                    //update

                   // echo "Exist agenda <br><br>";

    

                    $usuario->id = $search[0]->IdUser;

                 

                    $this->usuarioAgendaRepo->updateToLaravelSync($usuario);

                }else{

                  //  echo " Not Exist agenda<br><br>";

    

                    

                    $this->usuarioAgendaRepo->insertToLaravelSync($usuario);

                    //insert

                }

            }else{

                $search  = $this->usuarioCapacitacionRepo->getUsuarioEmailYPassword($usuario);

                $usuario->tipoUsuario = $usuario->tipoUsuarioCapacitacion;

                if(!empty($search)){

                    //update

                   // echo "Exist plataforma<br><br>";

    

                    $usuario->id = $search[0]->IdUser;

                 

                    $this->usuarioCapacitacionRepo->updateToLaravelSync($usuario);

                    

                }else{

                   // echo " Not Exist plataforma<br><br>";

    

                    

                     

                    $this->usuarioCapacitacionRepo->insertToLaravelSync($usuario);

                    $search  = $this->usuarioCapacitacionRepo->getUsuarioEmailYPassword($usuario);

                    $id = $search[0]->IdUser;

                    $tipo =$usuario->tipoUsuario;

                    if($tipo==1){

                        $this->usuarioCapacitacionRepo->insertEmpresa($usuario,$id);

                    }else if($tipo==2){

                        $this->usuarioCapacitacionRepo->insertEmpleado($usuario,$id,$usuario->curso);

                    }

                    //insert

                }

            }

        }

    }

    public function syncLaravel($usuarios,$sistema){

        foreach ($usuarios as $key => $usuario) {

            # code...

            $search  = $this->usuarioRepo->getUsuarioEmailYPassword($usuario);

            $usuario->name;

            $usuario->password;

            $usuario->sistema=$sistema;

            $usuario->nombre=  $usuario->name;

            $usuario->apellidos=  "";

            

            $usuario->email= $usuario->name;

            $usuario->imagen="placeholder.jpg";

           $usuario->creado=date('Y-m-d');

            $usuario->modificado=date('Y-m-d');

            $usuario->eliminado=date('Y-m-d');

            $usuario->nativo=2;

            $usuario->estado = $usuario->isEnabled;

            $usuario->tipoUsuario = $usuario->typeuser;

           

            if($sistema=="Agenda"){

                //$usuario->email = $usuario->login;

                $usuario->sistemaA="tipoUsuarioAgenda";

            }else if($sistema=="Plataforma"){

                $usuario->sistemaA="tipoUsuarioCapacitacion";

            }

            if(!empty($search)){

                //update

               //echo "Exist<br><br>";



                $usuario->id = $search[0]->id;

             

                $this->usuarioRepo->updateFromLaravelSync($usuario);

            }else{

               // echo " Not Exist<br><br>";



               

                $this->usuarioRepo->insertFromLaravelSync($usuario);

                //insert

            }

        }

    }

}

/*

$c = new UsuarioController();

$c->syncUsers();*/

?>