

<?php $__env->startSection('title', 'Jessika Cavallini'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1 class="m-0 text-dark">Obras de Arte</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(URL::asset('plugins/sceditor/minified/themes/default.min.css')); ?>" />

<script src="<?php echo e(URL::asset('plugins/sceditor/minified/sceditor.min.js')); ?>?v=<?php echo e(AppHelper::getVersion()); ?>"></script>
<script src="<?php echo e(URL::asset('plugins/sceditor/minified/icons/monocons.js')); ?>?v=<?php echo e(AppHelper::getVersion()); ?>"></script>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <form onsubmit="return save(event)" id="addForm">
                            <div class="row" style="">
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Nombre</label>
                                    <input type="text" id="nombre" name="nombre" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Nombre(en)</label>
                                    <input type="text" id="nombre_en" name="nombre_en" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Técnica</label>
                                    <input type="text" id="technique" name="technique"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Técnica(en)</label>
                                    <input type="text" id="technique_en" name="technique_en" class="form-control w-100"  required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Colección</label>
                                    <input type="text" id="collection" name="collection"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Colección(en)</label>
                                    <input type="text" id="collection_en" name="collection_en" class="form-control w-100"   required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Dimensiones</label>
                                    <input type="text" id="dimensions" name="dimensions" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Precio</label>
                                    <input type="text" id="price" name="price" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Año creación: <span id="rangeval"><?php echo e(date('Y')); ?><!-- Default value --></span></label>
                                    <input type="range" id="elaborated_year" name="elaborated_year" onInput="$('#rangeval').html($(this).val())" name="elaborated_year" value="<?php echo e(date('Y')); ?>"  class="form- w-100" min="1900" max="2099" step="1" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-12">
                                    <label class="w-100 font-weight-bold">Descripción de la obra</label>
                                    <textarea id="descripcion" class="form-control w-100" required style="height:300px"></textarea>
                                </div>
                                <div class="col-sm-12">
                                    <label class="w-100 font-weight-bold">Descripción de la obra(en)</label>
                                    <textarea id="descripcion_en" class="form-control w-100" required style="height:300px"></textarea>
                                </div>
                                
                                <div class="col-sm-12">
                                    <label>Archivo</label>
                                    <input type="file" id="imagen" name="imagen" class="form-control" accept="image/png,image/jpeg" required/>
                                </div>
                                <div class="col-sm-12">
                                    <label>Marca de agua</label>
                                    <select id="marca" class="form-control"  required>
                                        <option value="0">Marca de agua blanca</option>
                                        <option value="1">Marca de agua oscura</option>
                                    </select>
                                </div>
                                <div class="col-sm-6 d-none">
                                    <label class="w-100 font-weight-bold">separacion</label>
                                    <input id="separacion" type="range" min="1" max="500" class="form- w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">opacidad</label>
                                    <input type="range" min="0.1" max="1.0" step="0.05" id="opacidad" class="form- w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                               <div class="row">
                                    <div class="col-sm-12 d-flex justify-content-center">
                                        <img id="imagenResultado" src="" alt="" class="w-100" style="max-width:250px">
                                    </div>
                               </div>
                                <div class="col-sm-12  d-flex justify-content-end" style="margin-top:10px">
                                   
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $route2 = route("pictures.index");?>
<input type="hidden" value="<?php echo e($route2); ?>" id="route" />
<script src="<?php echo e(URL::asset('js/pictures/add.js')); ?>?v=<?php echo e(AppHelper::getVersion()); ?>"></script>  

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Art-Gallery\resources\views/pictures/add.blade.php ENDPATH**/ ?>