
<div>
       <script src="<?php echo e(URL::asset('plugins/DataTables/datatables.min.js')); ?>"></script>
    <div class="row" style="padding-top:55px;margin-bottom:55px">
        <div class="col-sm-9">
            <h1 class="m-0 text-dark">Reparaciones <?php echo e($tipo2); ?></h1>
        </div>
        <div class="col-sm-3 d-flex justify-content-end align-items-center text-center">
            <div class="btn-group">
            <select name="table"  wire:model="table" class="form-control form-select" style="width:70px;margin-right:5px">
                <option value="completa">Completa</option>
                <option value="resumida">Resumida</option>
            </select>
                <select name="tipo"  wire:model="tipo" class="form-control form-select" style="width:120px;margin-right:5px">
                    <option value="default">Default</option>
                    <option value="completadas">Mostrar reparaciones completadas</option>
                    <option value="pendientes">Mostrar reparaciones pendientes</option>
                    <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($estado->id); ?>"><?php echo e($estado->label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <a href="<?php echo e(route('reparaciones.create')); ?>" class="btn btn-primary text-center d-flex justify-content-center align-items-center" style="width:35px;height:35px;"><i class="fa fa-plus"></i></a>
        </div>
    </div>


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <div class="row" style="">
                            
                            <div class="col-sm-12">
                                <div class="table-responsive">
                                    <?php if($reparaciones->count()>0): ?>
                                        <table class="table table-striped table-bordered w-100">
                                            <thead>
                                                <tr>
                                                    <?php if($table!="resumida"): ?>
                                                    <th>Serie</th>
                                                    <?php endif; ?>
                                                    <th>Nombre</th>
                                                    <?php if($table!="resumida"): ?>
                                                    <th>Teléfono</th>
                                                    <th>Defecto</th>
                                                    <th>Modelo</th>
                                                    <th>Fecha Abierto</th>
                                                    <?php endif; ?>
                                                    <th>Estado</th>
                                                    <th>Asignado a</th>
                                                    <th>Código</th>
                                                    <?php if($table!="resumida"): ?>
                                                     <th>Total General</th>
                                                    
                                                     <th>Garantía</th>
                                                     <?php endif; ?>
                                                    <th style="width:75px;">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $reparaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nivel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <?php if($table!="resumida"): ?>
                                                        <td>
                                                            <?php echo e($nivel->serial_number."  "); ?>

                                                        </td>
                                                        <?php endif; ?>
                                                        <td  style="min-width:245px;">
                                                            <?php echo e($nivel->name); ?>

                                                        </td>
                                                        <?php if($table!="resumida"): ?>
                                                        <td>
                                                            <?php echo e($nivel->telephone); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($nivel->defect); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($nivel->model_name); ?>

                                                        </td>
                                                        <td style="min-width:145px;">
                                                            <?php echo e($nivel->date_opening); ?>

                                                        </td>
                                                        <?php endif; ?>
                                                       <td style="min-width:145px;font-size:12px">
                                                            <div class="container-status" style="background:<?php echo e($nivel->bg_color); ?>;color:<?php echo e($nivel->fg_color); ?>">
                                                                <?php echo e($nivel->label); ?>

                                                            </div>
                                                                
                                                       </td>
                                                       <td>
                                                            <?php echo e($nivel->first_name." ".$nivel->last_name); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($nivel->code); ?>

                                                        </td>
                                                        <?php if($table!="resumida"): ?>
                                                        <td style="min-width:115px;">
                                                            ₡<?php echo e(number_format($nivel->grand_total,2,"."," ")); ?>

                                                        </td>
                                                       
                                                        <td>
                                                            <?php if($nivel->warranty=='false'): ?>
                                                                Sin garantía
                                                            <?php endif; ?>
                                                            <?php if($nivel->warranty!='false'): ?>
                                                                <?php $warranty =json_decode($nivel->warranty,true); ?>
                                                                <?php $c =$warranty["warranty_duration"]; ?>
                                                               
                                                                <?php if( is_null($nivel->date_closing)!=true && is_null($c)!=true): ?>
                                                                    <?php $warranty =json_decode($nivel->warranty,true); ?>
                                                                    <?php $c =$warranty["warranty_duration"];
                                                                        $d = date_create($nivel->date_closing);
                                                                        $f = "$c days";
                                                                        
                                                                        $newDate = date_add($d,date_interval_create_from_date_string($f));
                                                                        $date = date_create(date("d-m-Y"));
                                                                        if($newDate <$date){
                                                                            $dd =date_format($newDate,"d-m-Y");
                                                                            echo "Garantía expiró en \" $dd \"";
                                                                        }else{
                                                                            echo date_format($newDate,"d-m-Y");
                                                                        }
                                                                        
                                                                    ?>
                                                                <?php endif; ?>
                                                                <?php if( (is_null($nivel->date_closing)==true && is_null($c)==true) ): ?>
                                                                     Sin garantía
                                                                <?php endif; ?>
                                                                <?php if( (is_null($nivel->date_closing)==true && is_null($c)!=true) ): ?>
                                                                     Sin garantía
                                                                <?php endif; ?>
                                                            <?php endif; ?>

                                                            
                                                        </td>
                                                        <?php endif; ?>
                                                        <td style="width:125px;">
                                                           
                                                            <div class="dropdown">
                                                                <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                    <i class="fa fa-cog"></i>
                                                                </button>
                                                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                                    <a class="dropdown-item" href="<?php echo e(route('reparaciones.edit',[$nivel->idRepair])); ?>">Editar</a>
                                                                    <a class="dropdown-item" href="<?php echo e(route('reparaciones.view',[$nivel->idRepair])); ?>">Ver</a>
                                                                    <a class="dropdown-item" href="#" onclick="loadModalComentarios(<?php echo e($nivel->idRepair); ?>,'<?php echo e(json_encode($nivel->comment)); ?>')">Agregar Comentario</a>
                                                                    <a class="dropdown-item" href="#"  onclick="loadModalEstados(<?php echo e($nivel->idRepair); ?>,<?php echo e($nivel->status); ?>)">Cambiar Estado</a>
                                                                    <a class="dropdown-item" href="#"  onclick="loadModalPago(<?php echo e($nivel->idRepair); ?>)">Pagos</a>
                                                                    <a class="dropdown-item" href="#"  onclick="downloadRepair(<?php echo e($nivel->idRepair); ?>)">Reporte</a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>    
                                    <?php endif; ?>
                                    <?php if($reparaciones->count()==0): ?>
                                        <h2>No hay reparaciones</h2>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $route2 = route("reparaciones.index");?>
    <input type="hidden" value="<?php echo e($route2); ?>" id="route" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.2/jspdf.min.js"></script>
  <script src="https://unpkg.com/jspdf-autotable@3.5.22/dist/jspdf.plugin.autotable.js"></script>
  <script src="<?php echo e(URL::asset('js/mask.js')); ?>"></script>  
    <script src="<?php echo e(URL::asset('js/reparaciones/list.js')); ?>"></script> 
    </div>  

<?php /**PATH C:\xampp\htdocs\Vega System\vegasys\resources\views/livewire/reparaciones.blade.php ENDPATH**/ ?>