

<?php $__env->startSection('title', 'Dr. Max Guth'); ?>

<?php $__env->startSection('content_header'); ?>
       <script src="<?php echo e(URL::asset('plugins/DataTables/datatables.min.js')); ?>"></script>
    <div class="row">
        <div class="col-sm-10">
            <h1 class="m-0 text-dark">Servicios</h1>
        </div>
        <div class="col-sm-2 d-flex justify-content-end align-items-center text-center">
            <a href="<?php echo e(route('servicios.create')); ?>" class="btn btn-primary text-center d-flex justify-content-center align-items-center" style="width:35px;height:35px;"><i class="fa fa-plus"></i></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <div class="row" style="">
                            
                            <div class="col-sm-12">
                                <div class="">
                                    <?php if($servicios->count()>0): ?>
                                        <table class="table table-striped table-bordered w-100">
                                            <thead>
                                                <tr>
                                                    <th>Titulo</th>
                                                    <th>Portada</th>
                                                    <th>Visitas</th>
                                                    <th>Calificación</th>
                                                    <th style="width:75px;">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $servicios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nivel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <?php echo e($nivel->titulo); ?>

                                                        </td>
                                                        <td>
                                                           <img src="<?php echo e(asset('assets/servicios/'.$nivel->portada)); ?>" style="width:45px"/>
                                                        </td>
                                                        <td>
                                                            <?php echo e($nivel->visitas); ?>

                                                        </td>
                                                        <td>
                                                            <?php 
                                                                if($nivel->valorado ==0){
                                                                    $countStarts = 0;
                                                                }else{
                                                                    $countStarts = $nivel->totalValorizado/$nivel->valorado;
                                                                }
                                                                
                                                            ?>
                                                           <?php if($countStarts==0): ?>
                                                                <span><i class="fa fa-star-o"></i></span>
                                                                <span><i class="fa fa-star-o"></i></span>
                                                                <span><i class="fa fa-star-o"></i></span>
                                                                <span><i class="fa fa-star-o"></i></span>
                                                                <span><i class="fa fa-star-o"></i></span>
                                                            <?php endif; ?> 
                                                            <?php if($countStarts!=0): ?>
                                                                <?php $indexP=(int)round($countStarts); ?>
                                                                <?php for($i=0;$i<$indexP;$i++): ?>
                                                                    <span class="text-warning"><i class="fa fa-star-o"></i></span>
                                                                <?php endfor; ?>
                                                                <?php $index=(int)round((5-$countStarts)); ?>
                                                                <?php for($i=0;$i<$index;$i++): ?>
                                                                    <span class=""><i class="fa fa-star-o"></i></span>
                                                                <?php endfor; ?>
                                                            <?php endif; ?> 
                                                            
                                                        </td>
                                                        <td style="width:125px;" class="d-flex justify-content-center">
                                                            <?php if($nivel->estado==0): ?>
                                                                <form action='<?php echo e(route("servicios.destroy", [$nivel])); ?>' method="post" onsubmit="return validateEstado(event,this,<?php echo e($nivel->idServicio); ?>,1)">
                                                                    <?php echo method_field("delete"); ?>
                                                                    <?php echo csrf_field(); ?>
                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">
                                                                        <i class="fa fa-times"></i>
                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>
                                                            <?php if($nivel->estado==1): ?>
                                                                <form action='<?php echo e(route("servicios.destroy", [$nivel])); ?>' method="post" onsubmit="return validateEstado(event,this,<?php echo e($nivel->idServicio); ?>,0)">
                                                                    <?php echo method_field("delete"); ?>
                                                                    <?php echo csrf_field(); ?>
                                                                    <button type="submit" class="btn btn-info text-white" style="margin-left:5px;">
                                                                        <i class="fa fa-check"></i>
                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>
                                                            <a href="<?php echo e(route('servicios.edit',[$nivel])); ?>"  class="btn btn-warning text-white" style="margin-left:5px;">
                                                                        <i class="fa fa-edit"></i>
                                                            </a>
                                                            <form action='<?php echo e(route("servicios.destroy", [$nivel])); ?>' method="post" onsubmit="return validate(event,this,<?php echo e($nivel->idServicio); ?>,1)">
                                                                    <?php echo method_field("delete"); ?>
                                                                    <?php echo csrf_field(); ?>
                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">
                                                                        <i class="fa fa-trash"></i>
                                                                    </button>
                                                                </form>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>    
                                    <?php endif; ?>
                                    <?php if($servicios->count()==0): ?>
                                        <h2>No hay servicios</h2>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $route2 = route("servicios.index");?>
    <input type="hidden" value="<?php echo e($route2); ?>" id="route" />

    <script src="<?php echo e(URL::asset('js/servicios/list.js')); ?>"></script>   
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Vega System\drmax\resources\views/servicios/index.blade.php ENDPATH**/ ?>