


<?php $__env->startSection('title', 'Jessika Cavallini'); ?>

<?php $__env->startSection('content_header'); ?>
       <script src="<?php echo e(URL::asset('plugins/DataTables/datatables.min.js')); ?>?v=<?php echo e(AppHelper::getVersion()); ?>"></script>
    <div class="row">
        <div class="col-sm-10">
            <h1 class="m-0 text-dark">Ventas</h1>
        </div>
      
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <div class="row" style="">
                            
                            <div class="col-sm-12">
                                <div class="">
                                    <?php if($transactions->count()>0): ?>
                                        <table class="table table-striped table-bordered w-100">
                                            <thead>
                                                <tr>
                                                    <th>Fecha De Compra</th>
                                                    <th>Cliente</th>
                                                    <th>Email</th>
                                                    <th>Precio</th>
                                                    <th>Estado Venta</th>
                                                    <th>Estado Entrega</th>
                                                    <th style="width:75px;">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nivel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <?php echo e(date_format(date_create($nivel->create_at),"H:i:s d-m-Y")); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($nivel->client); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($nivel->email); ?>

                                                        </td>
                                                      
                                                        <td>
                                                            $<?php echo e($nivel->total); ?>

                                                        </td>
                                                        <td>
                                                            <?php 
                                                            $status="";
                                                            $classes="";
                                                            if($nivel->status_payment==0){
                                                                $status="Debido";
                                                                $classes="btn-warning text-white";
                                                            }
                                                            if($nivel->status_payment==1){
                                                                $status="Pagado";
                                                                $classes="btn-success text-white";
                                                            }
                                                            if($nivel->status_payment==2){
                                                                $status="Cancelado";
                                                                $classes="btn-danger text-white";
                                                            } ?>
                                                            <div class="dropdown">
                                                                <button class="btn <?php echo e($classes); ?> dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                   <?php echo e($status); ?>

                                                                </button>
                                                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                                    <a class="dropdown-item" href="#" onclick="setStatusPayment(0,<?php echo e($nivel->id); ?>)">Debido</a>
                                                                    <a class="dropdown-item" href="#"  onclick="setStatusPayment(1,<?php echo e($nivel->id); ?>)">Pagado</a>
                                                                    <a class="dropdown-item" href="#"  onclick="setStatusPayment(2,<?php echo e($nivel->id); ?>)">Cancelado</a>
                                                                </div>
                                                            </div>
                                                            
                                                        </td>
                                                        <td>
                                                            <?php
                                                            $status="";
                                                            $classes="";
                                                            if($nivel->status_send==0){
                                                                $status="No entregado";
                                                                $classes="btn-warning text-white";
                                                            }
                                                            if($nivel->status_send==1){
                                                                $status="Entregado";
                                                                $classes="btn-success text-white";
                                                            }
                                                             ?>
                                                            <div class="dropdown">
                                                                <button class="btn <?php echo e($classes); ?> dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                   <?php echo e($status); ?>

                                                                </button>
                                                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                                    <a class="dropdown-item" href="#" onclick="setStatusSend(0,<?php echo e($nivel->id); ?>)">No entregado</a>
                                                                    <a class="dropdown-item" href="#"  onclick="setStatusSend(1,<?php echo e($nivel->id); ?>)">Entregado</a>
                                                                </div>
                                                            </div>
                                                           
                                                           
                                                        </td>
                                                        <td style="width:125px;" >
                                                            <button type="button" class="btn btn-success" onClick="loadDetails(<?php echo e($nivel->id); ?>)" style="margin-left:5px;">
                                                                        <i class="fa fa-eye"></i>
                                                                    </button>
                                                       
                                                        </td>
                                                           
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>    
                                    <?php endif; ?>
                                    <?php if($transactions->count()==0): ?>
                                        <h2>No hay ventas</h2>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('./transactions/include/detail', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $route2 = route("transactions.index");?>
    <input type="hidden" value="<?php echo e($route2); ?>" id="route" />

    <script src="<?php echo e(URL::asset('js/transactions/list.js')); ?>?v=<?php echo e(AppHelper::getVersion()); ?>"></script>   
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Art-Gallery\resources\views/transactions/index.blade.php ENDPATH**/ ?>