<div class="modal fade" id="modalGallery" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Galería</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table id="galeriaTable" class="table table-striped table-bordered w-100">
            <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Imagen</th>
                    <th >Acciones</th>
                </tr>
            </thead>
            <tbody>
                
            </tbody>
        </table>    
      </div>
      <div class="modal-footer">
       
      </div>
    </div>
  </div>
</div>

<script>
  $(document).ready(async function(){
    //galeriaTable
    $.ajaxSetup({
             headers: {
                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
             }
         });
           $.ajax({
             type:'POST',
             url:'/admin/gallery/imagenes',
             data:{},
             processData: false,
             contentType: false,
             success:function(data){
                let json= JSON.parse(data);
                console.log(json);
                $('#galeriaTable').DataTable({
                    destroy: true,
                  language: {
                    url: "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json",
                  },
                  responsive: true,
                //  serverSide: true,
                  "processing": true,
                 // ajax: '/admin/gallery/imagenes',
                  "order":[],
                  data:json,
                  columns: [
                        {data: 'nombre'},
                        {data: 'imagen',
                          render: function (data, type, row) {
                            return '<img src="'+row.imagen+'" style="width:35px;height:30px;"/>'
                          }
                        },
                        {data: 'idGaleria',
                          render: function (data, type, row) {
                            console.log(data,type,row);
                            return '<button type="button" class="btn btn-info text-white" onclick="copy(\''+row.imagen+'\')"><span><i class="fa fa-clipboard"></i></span></button>';
                          }
                        }
                    ],
                    "aoColumns":[
                      { mData: 'nombre' },
                      {data: 'imagen'},
                              { mData: 'idGaleria' },
                    ],
                  "columnDefs": [
                    { "width": "50px","sortable":false, "targets": 2 },
                    //{ "width": "120px","sortable":true, "targets": 3 },
                  //  { "width": "50px","sortable":false, "targets": 2 }
                  ],
                  //dom: 'Bfrtip',
                  buttons: [],
                    initComplete: function () {
                        
                      
                      $(".spin").css("display","none");
                      }
                });
             },
             error:function(data){
                 console.log(data);
                 $(".spin").css('display','none');
                
             }

           });
   
  })
</script><?php /**PATH C:\xampp\htdocs\Europaplus\resources\views/includes/galeria.blade.php ENDPATH**/ ?>