@extends('adminlte::page')


@section('title', 'Sistema TI')

@section('content_header')
       <script src="{{ URL::asset('plugins/DataTables/datatables.min.js')}}?v={{AppHelper::getVersion()}}"></script>
    <div class="row">
        <div class="col-sm-10">
            <h1 class="m-0 text-dark">VPN</h1>
        </div>
        <div class="col-sm-2 d-flex justify-content-end align-items-center text-center">
            <a href="{{route('vpn.create')}}" class="btn btn-primary text-center d-flex justify-content-center align-items-center" style="width:35px;height:35px;"><i class="fa fa-plus"></i></a>
        </div>
    </div>
@stop

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <div class="row" style="">
                            
                            <div class="col-sm-12">
                                <div class="">
                                    @if($equipos->count()>0)
                                        <table class="table table-striped table-bordered w-100">
                                            <thead>
                                                <tr>
                                                 
                                                    <th>Nombre</th>
                                                    <th>Usuario</th>
                                                    <th>Contraseña</th>
                                                    <th style="width:75px;">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($equipos as $nivel)
                                                    <tr>
                                                    <td>
                                                            {{$nivel->nombre}}
                                                        </td>
                                                        <td>
                                                            {{$nivel->usuario}}
                                                        </td>
                                                        
                                                      
                                                        <td>
                                                            {{$nivel->password}}
                                                        </td>
                                                      
                                                        
                                                        <td style="width:125px;" >
                                                            <div class="d-flex">
                                                            
                                                             <a href="{{route('vpn.edit',[$nivel])}}"  class="btn btn-warning text-white" style="margin-left:5px;">
                                                                        <i class="fa fa-edit"></i>
                                                            </a> 
                                                         
                                                            <form action='{{route("inventario.destroy", [$nivel])}}' method="post" onsubmit="return validate(event,this,{{$nivel->id}},1)">
                                                                    @method("delete")
                                                                    @csrf
                                                                    <button type="submit" class="btn btn-danger" style="margin-left:5px;">
                                                                        <i class="fa fa-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                       
                                                        </td>
                                                           
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>    
                                    @endif
                                    @if($equipos->count()==0)
                                        <h2>No hay inventario</h2>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $route2 = route("vpn.index");?>
    <input type="hidden" value="{{$route2}}" id="route" />

    <script src="{{ URL::asset('js/vpn/list.js')}}?v={{AppHelper::getVersion()}}"></script>   
@stop
