@extends('adminlte::page')

@section('title', 'Sistema TI')

@section('content_header')
    <h1 class="m-0 text-dark">Inventario Equipos::Editar</h1>
@stop

@section('content')
<link rel="stylesheet" href="{{ URL::asset('plugins/sceditor/minified/themes/default.min.css') }}" />

<script src="{{ URL::asset('plugins/sceditor/minified/sceditor.min.js')}}?v={{AppHelper::getVersion()}}"></script>
<script src="{{ URL::asset('plugins/sceditor/minified/icons/monocons.js')}}?v={{AppHelper::getVersion()}}"></script>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="flex-container">
                        <form onsubmit="return save(event)" id="addForm">
                            <div class="row" style="">
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Sistema Operativo</label>
                                    <input type="text" id="so" name="so" value="{{$equipo->so}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Departamento</label>
                                    <input type="text" id="departamento" name="departamento" value="{{$equipo->departamento}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Marca</label>
                                    <input type="text" id="marca" name="marca" value="{{$equipo->marca}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Modelo</label>
                                    <input type="text" id="modelo" name="modelo" value="{{$equipo->modelo}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Número de Serie</label>
                                    <input type="text" id="numero_serie" name="numero_serie" value="{{$equipo->numero_serie}}" class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">IP</label>
                                    <input type="text" id="ip" name="ip" class="form-control w-100" value="{{$equipo->ip}}" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Dirección Mac</label>
                                    <input type="text" id="mac" name="mac" class="form-control w-100" value="{{$equipo->mac}}" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">MAC Wifi</label>
                                    <input type="text" id="id_equipo" name="id_equipo"  value="{{$equipo->id_equipo}}"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Ubicación</label>
                                    <input type="text" id="ubicacion" name="ubicacion"  value="{{$equipo->ubicacion}}"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">HD</label>
                                    <input type="text" id="hd" name="hd"  value="{{$equipo->hd}}"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">RAM</label>
                                    <input type="text" id="ram" name="ram"  value="{{$equipo->ram}}"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Procesador</label>
                                    <input type="text" id="procesador" name="procesador"  value="{{$equipo->procesador}}"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Empresa</label>
                                    <input type="text" id="empresa" name="empresa"  value="{{$equipo->empresa}}"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Número de licencia</label>
                                    <input type="text" id="licencia" name="licencia"  value="{{$equipo->licencia}}"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Costo</label>
                                    <input type="text" id="costo" name="costo"  value="{{$equipo->costo}}"  class="form-control w-100" required/>
                                    <span class="text-danger font-weight-bold"></span>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Tipo de dispositivo</label>
                                    <select id="isPC" name="isPC" value="{{$equipo->isPC}}" class="form-select">
                                        <option value="0" @if($equipo->isPC==0) selected @endif >PC</option>
                                        <option value="1" @if($equipo->isPC==1) selected @endif>Portatil</option>
                                    </select>
                                </div>
                                <div class="col-sm-6">
                                    <label class="w-100 font-weight-bold">Estado</label>
                                    <select id="estado" name="estado" value="{{$equipo->estado}}" class="form-select">
                                        <option value="0" @if($equipo->estado==0) selected @endif >Bueno</option>
                                        <option value="1" @if($equipo->estado==1) selected @endif>Regular</option>
                                        <option value="2" @if($equipo->estado==2) selected @endif>Malo</option>
                                    </select>
                                </div>
                                <div class="col-sm-12  d-flex justify-content-end" style="margin-top:10px">
                                   <input type="hidden" id="id" name="id" value="{{$equipo->id}}" />
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $route2 = route("inventario.index");?>
<input type="hidden" value="{{$route2}}" id="route" />
<script src="{{ URL::asset('js/inventario/edit.js')}}?v={{AppHelper::getVersion()}}"></script>  

@stop
