$(document).ready(function(){
    $('#usuario').select2({});
    $("#usuario").val(null).trigger("change"); 
})
function save(e) {
    // $(".spin").css("display","flex");
    e.preventDefault();

    let cantidadErrores = 0;

    if (cantidadErrores == 0) {
        console.log("Guardando");
        Swal.fire({
            title: "Subiendo...",
            html: '<div class="progress"><div class="progress-bar" id="progress" style="width:0%">0%</div></div>',
            icon: 'warning',
            showCancelButton: false,
            showConfirmButton: false,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: "A",
            cancelButtonText: "C"
        }).then((result) => {
            if (result.value) {
                callback(true);
            } else {
                callback(false);
            }
        });

        let form = new FormData($("#addForm")[0]);
      


        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            xhr: function () {
                let xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener("progress", function (e) {
                    if (e.lengthComputable) {
                        console.log(e.loaded, e.total);
                        let p = ((e.loaded / e.total) * 100);
                        p = p.toFixed(0);
                        $("#progress").css("width", p + "%");
                        $("#progress").html(p + "%");
                        if (p == 100) {
                            setTimeout(() => {
                                $("#progress").html("Procesando...");
                            }, 1500);
                        }
                    }
                });
                return xhr;
            },
            type: 'POST',
            url: $("#route").val() + '/getHistorialUsuario',
            data: form,
            processData: false,
            contentType: false,
            success: function (data) {
              ;
                $(".spin").css('display', 'none');
                let json = JSON.parse(data);
                console.log(json)
                if (json) {
                    let rsp = alertTimeCorrect("Excelente", "Generando Excel", function (response) {
                         if(json.length==0){
                             let name ="Default";
                        generateExcel(json,name);
                         }else{
                             let name =json[0].usuario;
                        generateExcel(json,name);
                         }
                        
                       
                    });
                } else {
                    alertError("Error", "No se pudo realizar la consulta");
                }

            },
            error: function (data) {
                console.log(data);
                $(".spin").css('display', 'none');
                alertError("Error en el servidor");
            }

        });
    }
}
function generateData(data,nombre){
    let array=[["Historial de usuario:"+nombre],["Fecha","Tipo","Equipo","Comentarios"]];
    for(let i=0;i<data.length;i++){
   let temp ;
   let tipo = data[i].tipo_movimiento=="entrega"?"Entrega":"Recibido";
   let name =data[i].numero_serie+" "+data[i].marca+" "+data[i].modelo;
   temp =[getDateComplete(new Date(data[i].movement_date)),tipo,name,data[i].comentarios];
      array.push(temp);
      
    }
    return array;
}
function sheet_from_array_of_arrays(data, opts) {
    var ws = {};
    var range = {s: {c:10000000, r:10000000}, e: {c:0, r:0 }};
    for(var R = 0; R != data.length; ++R) {
      for(var C = 0; C != data[R].length; ++C) {
        if(range.s.r > R) range.s.r = R;
        if(range.s.c > C) range.s.c = C;
        if(range.e.r < R) range.e.r = R;
        if(range.e.c < C) range.e.c = C;
        var cell = {v: data[R][C] };
        if(cell.v == null) continue;
        var cell_ref = XLSX.utils.encode_cell({c:C,r:R});
        
        if(typeof cell.v === 'number') cell.t = 'n';
        else if(typeof cell.v === 'boolean') cell.t = 'b';
        else if(cell.v instanceof Date) {
          cell.t = 'n'; cell.z = XLSX.SSF._table[14];
          cell.v = datenum(cell.v);
        }
        else cell.t = 's';
        
        /*if(C == 0){
          cell.s={
            font:{
              bold:true,
            }
          }
        }*/
         if(R == 0){
           cell.s={
            
            font:{
              bold:true,
               sz: 16,
            }
          }
         }
        if(R == 1){
          cell.s={
            fill:{
              fgColor:{ rgb: "0e84b9" }
            },
            font:{
              bold:true,
               sz: 14,
              color: { rgb: "ffffff" }
            }
          }
        }
        
        ws[cell_ref] = cell;
      }
    }
    if(range.s.c < 10000000) ws['!ref'] = XLSX.utils.encode_range(range);
    return ws;
  }
  function Workbook() {
    if(!(this instanceof Workbook)) return new Workbook();
    this.SheetNames = [];
    this.Sheets = {};
  }
  
function generateExcel(data,nombre){
    
    var wb = new Workbook();
  wb.Props = {
                Title: "Historial de inventario",
                Subject: "Historial",
                Author: "SAMAS",
                CreatedDate: new Date()
        };
  let formatData=generateData(data,nombre);
  console.log("Forma",formatData);
  wb.SheetNames.push("Historial");
  var ws = sheet_from_array_of_arrays(formatData);
  var wscols = [
    {wch:15},
    {wch:15},
    {wch:35},
    {wch:55},
];

ws['!cols'] = wscols;
const merge = [
  { s: { r:0, c: 0 }, e: { r: 0, c: 4 } }
];
ws["!merges"] = merge;
  wb.Sheets["Historial"] = ws;
  var wbout = XLSX.write(wb, {bookType:'xlsx', bookSST:true, type: 'binary'});
  let name='Historial Usuario '+new Date().toLocaleDateString()+'.xlsx';
  
  var excelBlob = new Blob([s2ab(wbout)],{type:"application/octet-stream"}, name);   
  saveAs(new Blob([s2ab(wbout)],{type:"application/octet-stream"}), name)
}
function s2ab(s) { 
    var buf = new ArrayBuffer(s.length);
var view = new Uint8Array(buf);
for (var i=0; i!=s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
return buf; 
}