<?php

namespace App\Http\Controllers;

use App\Models\TiDirectorio;
use Illuminate\Http\Request;

class DirectorioController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    /**
     * Display a listing of the resource.
     */
   
     public function index()
     {
         //
         $equipos = TiDirectorio::where('status','<=','1')->get();
         $data=[
             "equipos"=>$equipos
         ];
         return view("pin.index",$data);
     }
 
     /**
      * Show the form for creating a new resource.
      */
     public function create()
     {
         //
         $data=[];
         return view('pin.add');
     }
 
     /**
      * Store a newly created resource in storage.
      */
     public function store(Request $request)
     {
         //
         $input = $request->all();
 
         try{
             $equipo = new TiDirectorio($input);
             $equipo['status']=1;
             $equipo['create_at']=date('Y-m-d');
             $equipo->save();
             echo json_encode(true);
         }catch(\Illuminate\Database\QueryException $e){
             \Log::emergency(json_encode($e));
             echo json_encode(false);
         }
     }
 
     /**
      * Display the specified resource.
      */
     public function show(string $id)
     {
         //
     }
 
     /**
      * Show the form for editing the specified resource.
      */
     public function edit(string $id)
     {
         //
         $equipo = TiDirectorio::where('id','=',$id)->first();
         $data=[
             'equipo'=>$equipo
         ];
         return view('pin.edit',$data);
     }
 
     /**
      * Update the specified resource in storage.
      */
     public function update(Request $request)
     {
         //
         $input = $request->all();
 
         try{
             $equipo = TiDirectorio::where('id','=',$input['id'])->first();
             $equipo->pin =$input['pin'];
             $equipo->usuario =$input['usuario'];
             $equipo->password =$input['password'];
             $equipo->save();
             echo json_encode(true);
         }catch(\Illuminate\Database\QueryException $e){
             \Log::emergency(json_encode($e));
             echo json_encode(false);
         }
     }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $input = $request->all();
        try{
            $equipo = TiDirectorio::where('id','=',$input['id'])->first();
            $equipo->status = 2;
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
        //
    }
}
