<?php

namespace App\Http\Controllers;

use App\Models\TiConmutador;
use Illuminate\Http\Request;

class ConmutadorController extends Controller
{
    public function __construct(Request $request){
        parent::__construct($request);
    }
    public function index()
    {
        //
        $equipos = TiConmutador::where('status','<=','1')->get();
        $data=[
            "equipos"=>$equipos
        ];
        return view("conmutador.index",$data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $data=[];
        return view('conmutador.add');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = new TiConmutador($input);
            $equipo['status']=1;
            $equipo['create_at']=date('Y-m-d');
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $equipo = TiConmutador::where('id','=',$id)->first();
        $data=[
            'equipo'=>$equipo
        ];
        return view('conmutador.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //
        $input = $request->all();

        try{
            $equipo = TiConmutador::where('id','=',$input['id'])->first();
            $equipo->usuario =$input['usuario'];
            $equipo->aplicacion =$input['aplicacion'];
            $equipo->exit_sip =$input['exit_sip'];
            $equipo->ext_iax =$input['ext_iax'];
            $equipo->departamento =$input['departamento'];
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
        $input = $request->all();
        try{
            $equipo = TiConmutador::where('id','=',$input['id'])->first();
            $equipo->status = 2;
            $equipo->save();
            echo json_encode(true);
        }catch(\Illuminate\Database\QueryException $e){
            \Log::emergency(json_encode($e));
            echo json_encode(false);
        }
        //
    }
}
