/*!

 * Bootstrap-select v1.9.4 (http://silviomoreto.github.io/bootstrap-select)

 *

 * Copyright 2013-2016 bootstrap-select

 * Licensed under MIT (https://github.com/silviomoreto/bootstrap-select/blob/master/LICENSE)

 */



(function (root, factory) {

  if (typeof define === 'function' && define.amd) {

    // AMD. Register as an anonymous module unless amdModuleId is set

    define(["jquery"], function (a0) {

      return (factory(a0));

    });

  } else if (typeof exports === 'object') {

    // Node. Does not work with strict CommonJS, but

    // only CommonJS-like environments that support module.exports,

    // like Node.

    module.exports = factory(require("jquery"));

  } else {

    factory(jQuery);

  }

}(this, function (jQuery) {



(function ($) {

  $.fn.selectpicker.defaults = {

    noneSelectedText: 'Nothing selected',

    noneResultsText: 'No results match {0}',

    countSelectedText: function (numSelected, numTotal) {

      return (numSelected == 1) ? "{0} item selected" : "{0} items selected";

    },

    maxOptionsText: function (numAll, numGroup) {

      return [

        (numAll == 1) ? 'Limit reached ({n} item max)' : 'Limit reached ({n} items max)',

        (numGroup == 1) ? 'Group limit reached ({n} item max)' : 'Group limit reached ({n} items max)'

      ];

    },

    selectAllText: 'Select All',

    deselectAllText: 'Deselect All',

    multipleSeparator: ', '

  };

})(jQuery);





}));

