

$(document).ready(function () {

    if ($("table").length == 0) {

        $(".spin").css("display", "none");

    }

    $("table").DataTable({

        destroy: true,

        language: {

            url: "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json",

        },

        responsive: true,

        order: [],

        columnDefs: [

            { width: "50px", sortable: false, targets: 1 },

            //  { "width": "50px","sortable":false, "targets": 2 }

        ],

        //dom: 'Bfrtip',

        buttons: [],

        initComplete: function () {

            $(".spin").css("display", "none");

        },

    });

});



const removeItem = (id) => {

    confirmacionEliminar(

        "¿Desea eliminar el departamento?",

        "Aceptar",

        "Cancelar",

        function (response) {

            if (response) {

                let form = new FormData();

                $.ajaxSetup({

                    headers: {

                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),

                    },

                });

                console.log(id);

                form.append("id", id);

                $.ajax({

                    type: "POST",

                    url: "./admin/api/departamento.php?action=delete",

                    data: form,

                    processData: false,

                    contentType: false,

                    success: function (data) {

                        console.log(data);

                        $(".spin").css("display", "none");

                        let json = JSON.parse(data);

                        console.log(json);

                        if (json) {

                            let rsp = alertTimeCorrect(

                                "Excelente",

                                "Departamento eliminado",

                                function (response) {

                                    window.location.reload();

                                }

                            );

                        } else {

                            alertError("Error", "No se eliminó el departamento");

                        }

                    },

                    error: function (data) {

                        console.log(data);

                        $(".spin").css("display", "none");

                        alertError("Error en el servidor");

                    },

                });

            }

        }

    );

};







const statusItem = (id) => {

    confirmacionEliminar(

        "¿Desea cambiar el estado del departamento?",

        "Aceptar",

        "Cancelar",

        function (response) {

            if (response) {

                let form = new FormData();

                $.ajaxSetup({

                    headers: {

                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),

                    },

                });

                console.log(id);

                form.append("id", id);

                $.ajax({

                    type: "POST",

                    url: "./admin/api/departamento.php?action=status",

                    data: form,

                    processData: false,

                    contentType: false,

                    success: function (data) {

                        console.log(data);

                        $(".spin").css("display", "none");

                        let json = JSON.parse(data);

                        console.log(json);

                        if (json) {

                            let rsp = alertTimeCorrect(

                                "Excelente",

                                "Departamento actualizado",

                                function (response) {

                                    window.location.reload();

                                }

                            );

                        } else {

                            alertError("Error", "No se actualizó el departamento");

                        }

                    },

                    error: function (data) {

                        console.log(data);

                        $(".spin").css("display", "none");

                        alertError("Error en el servidor");

                    },

                });

            }

        }

    );

};

